/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.assertions.HTMLAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HTMLAssertionGui
extends AbstractAssertionGui
implements KeyListener,
ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 1L;
    private static final String WARNING_THRESHOLD_FIELD = "warningThresholdField";
    private static final String ERROR_THRESHOLD_FIELD = "errorThresholdField";
    private JTextField errorThresholdField = null;
    private JTextField warningThresholdField = null;
    private JCheckBox errorsOnly = null;
    private JComboBox docTypeBox = null;
    private JRadioButton htmlRadioButton = null;
    private JRadioButton xhtmlRadioButton = null;
    private JRadioButton xmlRadioButton = null;
    private FilePanel filePanel = null;

    public HTMLAssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "html_assertion_title";
    }

    public TestElement createTestElement() {
        HTMLAssertion el = new HTMLAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement inElement) {
        log.debug("HTMLAssertionGui.modifyTestElement() called");
        this.configureTestElement(inElement);
        String errorThresholdString = this.errorThresholdField.getText();
        long errorThreshold = 0L;
        try {
            errorThreshold = Long.parseLong(errorThresholdString);
        }
        catch (NumberFormatException e) {
            errorThreshold = 0L;
        }
        ((HTMLAssertion)inElement).setErrorThreshold(errorThreshold);
        String warningThresholdString = this.warningThresholdField.getText();
        long warningThreshold = 0L;
        try {
            warningThreshold = Long.parseLong(warningThresholdString);
        }
        catch (NumberFormatException e) {
            warningThreshold = 0L;
        }
        ((HTMLAssertion)inElement).setWarningThreshold(warningThreshold);
        String docTypeString = this.docTypeBox.getSelectedItem().toString();
        ((HTMLAssertion)inElement).setDoctype(docTypeString);
        boolean trackErrorsOnly = this.errorsOnly.isSelected();
        ((HTMLAssertion)inElement).setErrorsOnly(trackErrorsOnly);
        if (this.htmlRadioButton.isSelected()) {
            ((HTMLAssertion)inElement).setHTML();
        } else if (this.xhtmlRadioButton.isSelected()) {
            ((HTMLAssertion)inElement).setXHTML();
        } else {
            ((HTMLAssertion)inElement).setXML();
        }
        ((HTMLAssertion)inElement).setFilename(this.filePanel.getFilename());
    }

    public void clearGui() {
        super.clearGui();
        this.docTypeBox.setSelectedIndex(0);
        this.htmlRadioButton.setSelected(true);
        this.xhtmlRadioButton.setSelected(false);
        this.xmlRadioButton.setSelected(false);
        this.errorThresholdField.setText("0");
        this.warningThresholdField.setText("0");
        this.filePanel.setFilename("");
        this.errorsOnly.setSelected(false);
    }

    public void configure(TestElement inElement) {
        super.configure(inElement);
        HTMLAssertion lAssertion = (HTMLAssertion)inElement;
        this.errorThresholdField.setText(String.valueOf(lAssertion.getErrorThreshold()));
        this.warningThresholdField.setText(String.valueOf(lAssertion.getWarningThreshold()));
        this.errorsOnly.setSelected(lAssertion.isErrorsOnly());
        this.docTypeBox.setSelectedItem(lAssertion.getDoctype());
        if (lAssertion.isHTML()) {
            this.htmlRadioButton.setSelected(true);
        } else if (lAssertion.isXHTML()) {
            this.xhtmlRadioButton.setSelected(true);
        } else {
            this.xmlRadioButton.setSelected(true);
        }
        if (lAssertion.isErrorsOnly()) {
            this.warningThresholdField.setEnabled(false);
            this.warningThresholdField.setEditable(false);
        } else {
            this.warningThresholdField.setEnabled(true);
            this.warningThresholdField.setEditable(true);
        }
        this.filePanel.setFilename(lAssertion.getFilename());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        VerticalPanel assertionPanel = new VerticalPanel();
        assertionPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Tidy Settings"));
        HorizontalPanel docTypePanel = new HorizontalPanel();
        this.docTypeBox = new JComboBox<String>(new String[]{"omit", "auto", "strict", "loose"});
        docTypePanel.add((Component)new JLabel("Doctype:"));
        docTypePanel.add((Component)this.docTypeBox);
        assertionPanel.add((Component)docTypePanel);
        VerticalPanel formatPanel = new VerticalPanel();
        formatPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Format"));
        this.htmlRadioButton = new JRadioButton("HTML", true);
        this.xhtmlRadioButton = new JRadioButton("XHTML", false);
        this.xmlRadioButton = new JRadioButton("XML", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.htmlRadioButton);
        buttonGroup.add(this.xhtmlRadioButton);
        buttonGroup.add(this.xmlRadioButton);
        formatPanel.add((Component)this.htmlRadioButton);
        formatPanel.add((Component)this.xhtmlRadioButton);
        formatPanel.add((Component)this.xmlRadioButton);
        assertionPanel.add((Component)formatPanel);
        this.errorsOnly = new JCheckBox("Errors only", false);
        this.errorsOnly.addActionListener(this);
        assertionPanel.add((Component)this.errorsOnly);
        HorizontalPanel thresholdPanel = new HorizontalPanel();
        thresholdPanel.add((Component)new JLabel("Error threshold:"));
        this.errorThresholdField = new JTextField("0", 5);
        this.errorThresholdField.setName(ERROR_THRESHOLD_FIELD);
        this.errorThresholdField.addKeyListener(this);
        thresholdPanel.add((Component)this.errorThresholdField);
        thresholdPanel.add((Component)new JLabel("Warning threshold:"));
        this.warningThresholdField = new JTextField("0", 5);
        this.warningThresholdField.setName(WARNING_THRESHOLD_FIELD);
        this.warningThresholdField.addKeyListener(this);
        thresholdPanel.add((Component)this.warningThresholdField);
        assertionPanel.add((Component)thresholdPanel);
        this.filePanel = new FilePanel(JMeterUtils.getResString((String)"html_assertion_file"), ".txt");
        assertionPanel.add((Component)this.filePanel);
        mainPanel.add((Component)assertionPanel, "North");
        this.add(mainPanel, "Center");
    }

    public void focusLost(FocusEvent inEvent) {
        String warningThresholdString;
        log.debug("HTMLAssertionGui.focusLost() called");
        String errorThresholdString = this.errorThresholdField.getText();
        if (errorThresholdString != null) {
            boolean isInvalid = false;
            try {
                long errorThreshold = Long.parseLong(errorThresholdString);
                if (errorThreshold < 0L) {
                    isInvalid = true;
                }
            }
            catch (NumberFormatException ex) {
                isInvalid = true;
            }
            if (isInvalid) {
                log.warn("HTMLAssertionGui: Error threshold Not a valid number!");
                JOptionPane.showMessageDialog(null, "Threshold for errors is invalid", "Error", 0);
            }
        }
        if ((warningThresholdString = this.warningThresholdField.getText()) != null) {
            boolean isInvalid = false;
            try {
                long warningThreshold = Long.parseLong(warningThresholdString);
                if (warningThreshold < 0L) {
                    isInvalid = true;
                }
            }
            catch (NumberFormatException ex) {
                isInvalid = true;
            }
            if (isInvalid) {
                log.warn("HTMLAssertionGui: Error threshold Not a valid number!");
                JOptionPane.showMessageDialog(null, "Threshold for warnings is invalid", "Error", 0);
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.errorsOnly.isSelected()) {
            this.warningThresholdField.setEnabled(false);
            this.warningThresholdField.setEditable(false);
        } else {
            this.warningThresholdField.setEnabled(true);
            this.warningThresholdField.setEditable(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String fieldName = e.getComponent().getName();
        if (fieldName.equals(WARNING_THRESHOLD_FIELD)) {
            this.validateInteger(this.warningThresholdField);
        }
        if (fieldName.equals(ERROR_THRESHOLD_FIELD)) {
            this.validateInteger(this.errorThresholdField);
        }
    }

    private void validateInteger(JTextField field) {
        block2: {
            try {
                Integer.parseInt(field.getText());
            }
            catch (NumberFormatException nfe) {
                int length = field.getText().length();
                if (length <= 0) break block2;
                JOptionPane.showMessageDialog((Component)((Object)this), "Only digits allowed", "Invalid data", 2);
                field.setText(field.getText().substring(0, length - 1));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

