/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.control.TestFragmentController;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class IncludeController
extends GenericController
implements ReplaceableController {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String INCLUDE_PATH = "IncludeController.includepath";
    private static final String prefix = JMeterUtils.getPropDefault((String)"includecontroller.prefix", (String)"");
    private HashTree subtree = null;
    private TestElement sub = null;

    public Object clone() {
        this.resolveReplacementSubTree(null);
        IncludeController clone = (IncludeController)((Object)super.clone());
        clone.setIncludePath(this.getIncludePath());
        if (this.subtree != null) {
            if (this.subtree.size() == 1) {
                for (TestElement this.sub : this.subtree.keySet()) {
                }
            }
            clone.subtree = (HashTree)this.subtree.clone();
            clone.sub = this.sub == null ? null : (TestElement)this.sub.clone();
        }
        return clone;
    }

    public void setIncludePath(String jmxfile) {
        this.setProperty(INCLUDE_PATH, jmxfile);
    }

    public String getIncludePath() {
        return this.getPropertyAsString(INCLUDE_PATH);
    }

    public HashTree getReplacementSubTree() {
        return this.subtree;
    }

    public TestElement getReplacementElement() {
        return this.sub;
    }

    public void resolveReplacementSubTree(JMeterTreeNode context) {
        this.subtree = this.loadIncludedElements();
    }

    protected HashTree loadIncludedElements() {
        String includePath = this.getIncludePath();
        HashTree tree = null;
        if (includePath != null && includePath.length() > 0) {
            try {
                String fileName = prefix + includePath;
                File file = new File(fileName);
                String absolutePath = file.getAbsolutePath();
                log.info("loadIncludedElements -- try to load included module: " + absolutePath);
                if (!file.exists() && !file.isAbsolute()) {
                    log.info("loadIncludedElements -failed for: " + absolutePath);
                    file = new File(FileServer.getFileServer().getBaseDir(), includePath);
                    log.info("loadIncludedElements -Attempting to read it from: " + absolutePath);
                    if (!file.exists()) {
                        log.error("loadIncludedElements -failed for: " + absolutePath);
                        throw new IOException("loadIncludedElements -failed for: " + absolutePath);
                    }
                }
                tree = SaveService.loadTree((File)file);
                tree = this.getProperBranch(tree);
                this.removeDisabledItems(tree);
                return tree;
            }
            catch (NoClassDefFoundError ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = "Missing jar file - see log for details";
                }
                log.warn("Missing jar file", (Throwable)ex);
                JMeterUtils.reportErrorToUser((String)msg);
            }
            catch (FileNotFoundException ex) {
                String msg = ex.getMessage();
                JMeterUtils.reportErrorToUser((String)msg);
                log.warn(msg);
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = "Unexpected error - see log for details";
                }
                JMeterUtils.reportErrorToUser((String)msg);
                log.warn("Unexpected error", (Throwable)ex);
            }
        }
        return tree;
    }

    private HashTree getProperBranch(HashTree tree) {
        for (TestElement item : new LinkedList(tree.list())) {
            if (item instanceof TestPlan) {
                return this.getProperBranch(tree.getTree((Object)item));
            }
            if (!(item instanceof TestFragmentController)) continue;
            return tree.getTree((Object)item);
        }
        log.warn("No Test Fragment was found in included Test Plan, returning empty HashTree");
        return new HashTree();
    }

    private void removeDisabledItems(HashTree tree) {
        for (TestElement item : new LinkedList(tree.list())) {
            if (!item.isEnabled()) {
                tree.remove((Object)item);
                continue;
            }
            this.removeDisabledItems(tree.getTree((Object)item));
        }
    }
}

