/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BackendListener
extends AbstractTestElement
implements Serializable,
SampleListener,
TestStateListener,
NoThreadClone,
Remoteable {
    private static final long serialVersionUID = 8184103677832024335L;
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    public static final String CLASSNAME = "classname";
    public static final String QUEUE_SIZE = "QUEUE_SIZE";
    private static final Object LOCK = new Object();
    public static final String ARGUMENTS = "arguments";
    private Class<?> clientClass;
    public static final String DEFAULT_QUEUE_SIZE = "5000";
    private static final transient SampleResult FINAL_SAMPLE_RESULT = new SampleResult();
    private transient String myName;
    private transient ListenerClientData listenerClientData;
    private static final Map<String, ListenerClientData> queuesByTestElementName = new ConcurrentHashMap<String, ListenerClientData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendListener() {
        Object object = LOCK;
        synchronized (object) {
            queuesByTestElementName.clear();
        }
        this.setArguments(new Arguments());
    }

    public Object clone() {
        BackendListener clone = (BackendListener)super.clone();
        clone.clientClass = this.clientClass;
        return clone;
    }

    private void initClass() {
        String name = this.getClassname().trim();
        try {
            this.clientClass = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            LOGGER.error(this.whoAmI() + "\tException initialising: " + name, (Throwable)e);
        }
    }

    private String whoAmI() {
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append("-");
        sb.append(this.getName());
        return sb.toString();
    }

    public void sampleOccurred(SampleEvent event) {
        Arguments args = this.getArguments();
        BackendListenerContext context = new BackendListenerContext(args);
        SampleResult sr = this.listenerClientData.client.createSampleResult(context, event.getResult());
        if (sr == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.getName() + "=>Dropping SampleResult:" + event.getResult());
            }
            return;
        }
        try {
            if (!this.listenerClientData.queue.offer(sr)) {
                this.listenerClientData.queueWaits.incrementAndGet();
                long t1 = System.nanoTime();
                this.listenerClientData.queue.put(sr);
                long t2 = System.nanoTime();
                this.listenerClientData.queueWaitTime.addAndGet(t2 - t1);
            }
        }
        catch (Exception err) {
            LOGGER.error("sampleOccurred, failed to queue the sample", (Throwable)err);
        }
    }

    static final void sendToListener(BackendListenerClient backendListenerClient, BackendListenerContext context, List<SampleResult> sampleResults) {
        if (sampleResults.size() > 0) {
            backendListenerClient.handleSampleResults(sampleResults, context);
            sampleResults.clear();
        }
    }

    static BackendListenerClient createBackendListenerClientImpl(Class<?> clientClass) {
        if (clientClass == null) {
            return new ErrorBackendListenerClient();
        }
        try {
            return (BackendListenerClient)clientClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("Exception creating: " + clientClass, (Throwable)e);
            return new ErrorBackendListenerClient();
        }
    }

    public void testStarted() {
        this.testStarted("local");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(String host) {
        int queueSize;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.whoAmI() + "\ttestStarted(" + host + ")");
        }
        String size = this.getQueueSize();
        try {
            queueSize = Integer.parseInt(size);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn("Invalid queue size '" + size + "' defaulting to " + DEFAULT_QUEUE_SIZE);
            queueSize = Integer.parseInt(DEFAULT_QUEUE_SIZE);
        }
        Object object = LOCK;
        synchronized (object) {
            this.myName = this.getName();
            this.listenerClientData = queuesByTestElementName.get(this.myName);
            if (this.listenerClientData == null) {
                this.initClass();
                BackendListenerClient backendListenerClient = BackendListener.createBackendListenerClientImpl(this.clientClass);
                BackendListenerContext context = new BackendListenerContext((Arguments)this.getArguments().clone());
                this.listenerClientData = new ListenerClientData();
                this.listenerClientData.queue = new ArrayBlockingQueue(queueSize);
                this.listenerClientData.queueWaits = new AtomicLong(0L);
                this.listenerClientData.queueWaitTime = new AtomicLong(0L);
                this.listenerClientData.latch = new CountDownLatch(1);
                this.listenerClientData.client = backendListenerClient;
                LOGGER.info(this.getName() + ":Starting worker with class:" + this.clientClass + " and queue capacity:" + this.getQueueSize());
                Worker worker = new Worker(backendListenerClient, (Arguments)this.getArguments().clone(), this.listenerClientData);
                worker.setDaemon(true);
                worker.start();
                LOGGER.info(this.getName() + ": Started  worker with class:" + this.clientClass);
                try {
                    backendListenerClient.setupTest(context);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed calling setupTest", e);
                }
                queuesByTestElementName.put(this.myName, this.listenerClientData);
            }
            this.listenerClientData.instanceCount++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String host) {
        Object object = LOCK;
        synchronized (object) {
            ListenerClientData listenerClientData = queuesByTestElementName.get(this.myName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("testEnded called on instance " + this.myName + "#" + listenerClientData.instanceCount);
            }
            listenerClientData.instanceCount--;
            if (listenerClientData.instanceCount > 0) {
                return;
            }
        }
        try {
            this.listenerClientData.queue.put(FINAL_SAMPLE_RESULT);
        }
        catch (Exception ex) {
            LOGGER.warn("testEnded() with exception:" + ex.getMessage(), (Throwable)ex);
        }
        if (this.listenerClientData.queueWaits.get() > 0L) {
            LOGGER.warn("QueueWaits: " + this.listenerClientData.queueWaits + "; QueueWaitTime: " + this.listenerClientData.queueWaitTime + " (nanoseconds), you may need to increase queue capacity, see property 'backend_queue_capacity'");
        }
        try {
            this.listenerClientData.latch.await();
            BackendListenerContext context = new BackendListenerContext(this.getArguments());
            this.listenerClientData.client.teardownTest(context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed calling teardownTest", e);
        }
    }

    public void testEnded() {
        this.testEnded("local");
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void setArguments(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)args));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setClassname(String classname) {
        this.setProperty(CLASSNAME, classname);
    }

    public String getClassname() {
        return this.getPropertyAsString(CLASSNAME);
    }

    public void setQueueSize(String queueSize) {
        this.setProperty(QUEUE_SIZE, queueSize, DEFAULT_QUEUE_SIZE);
    }

    public String getQueueSize() {
        return this.getPropertyAsString(QUEUE_SIZE, DEFAULT_QUEUE_SIZE);
    }

    static class ErrorBackendListenerClient
    extends AbstractBackendListenerClient {
        ErrorBackendListenerClient() {
        }

        @Override
        public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
            LOGGER.warn("ErrorBackendListenerClient#handleSampleResult called, noop");
            Thread.yield();
        }
    }

    private static final class Worker
    extends Thread {
        private final ListenerClientData listenerClientData;
        private final BackendListenerContext context;
        private final BackendListenerClient backendListenerClient;

        private Worker(BackendListenerClient backendListenerClient, Arguments arguments, ListenerClientData listenerClientData) {
            this.listenerClientData = listenerClientData;
            arguments.addArgument("TestElement.name", this.getName());
            this.context = new BackendListenerContext(arguments);
            this.backendListenerClient = backendListenerClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            ArrayList<SampleResult> sampleResults = new ArrayList<SampleResult>(this.listenerClientData.queue.size());
            try {
                try {
                    boolean endOfLoop = false;
                    while (!endOfLoop) {
                        if (isDebugEnabled) {
                            LOGGER.debug("Thread:" + Thread.currentThread().getName() + " taking SampleResult from queue:" + this.listenerClientData.queue.size());
                        }
                        SampleResult sampleResult = (SampleResult)this.listenerClientData.queue.take();
                        if (isDebugEnabled) {
                            LOGGER.debug("Thread:" + Thread.currentThread().getName() + " took SampleResult:" + sampleResult + ", isFinal:" + (sampleResult == FINAL_SAMPLE_RESULT));
                        }
                        while (!(endOfLoop = sampleResult == FINAL_SAMPLE_RESULT) && sampleResult != null) {
                            sampleResults.add(sampleResult);
                            if (isDebugEnabled) {
                                LOGGER.debug("Thread:" + Thread.currentThread().getName() + " polling from queue:" + this.listenerClientData.queue.size());
                            }
                            sampleResult = (SampleResult)this.listenerClientData.queue.poll();
                            if (!isDebugEnabled) continue;
                            LOGGER.debug("Thread:" + Thread.currentThread().getName() + " took from queue:" + sampleResult + ", isFinal:" + (sampleResult == FINAL_SAMPLE_RESULT));
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug("Thread:" + Thread.currentThread().getName() + " exiting with FINAL EVENT:" + (sampleResult == FINAL_SAMPLE_RESULT) + ", null:" + (sampleResult == null));
                        }
                        BackendListener.sendToListener(this.backendListenerClient, this.context, sampleResults);
                        if (endOfLoop) continue;
                        LockSupport.parkNanos(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BackendListener.sendToListener(this.backendListenerClient, this.context, sampleResults);
                LOGGER.info("Worker ended");
            }
            finally {
                this.listenerClientData.latch.countDown();
            }
        }
    }

    private static final class ListenerClientData {
        private BackendListenerClient client;
        private BlockingQueue<SampleResult> queue;
        private AtomicLong queueWaits;
        private AtomicLong queueWaitTime;
        private int instanceCount;
        private CountDownLatch latch;

        private ListenerClientData() {
        }
    }
}

