/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailerModel
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String MAIL_SMTP_HOST = "mail.smtp.host";
    private long failureCount = 0L;
    private long successCount = 0L;
    private boolean failureMsgSent = false;
    private boolean siteDown = false;
    private boolean successMsgSent = false;
    private static final String FROM_KEY = "MailerModel.fromAddress";
    private static final String TO_KEY = "MailerModel.addressie";
    private static final String HOST_KEY = "MailerModel.smtpHost";
    private static final String SUCCESS_SUBJECT = "MailerModel.successSubject";
    private static final String FAILURE_SUBJECT = "MailerModel.failureSubject";
    private static final String FAILURE_LIMIT_KEY = "MailerModel.failureLimit";
    private static final String SUCCESS_LIMIT_KEY = "MailerModel.successLimit";
    private static final String DEFAULT_LIMIT = "2";
    private transient ChangeListener changeListener;

    public MailerModel() {
        this.setProperty(SUCCESS_LIMIT_KEY, JMeterUtils.getPropDefault((String)"mailer.successlimit", (String)DEFAULT_LIMIT));
        this.setProperty(FAILURE_LIMIT_KEY, JMeterUtils.getPropDefault((String)"mailer.failurelimit", (String)DEFAULT_LIMIT));
    }

    public void addChangeListener(ChangeListener list) {
        this.changeListener = list;
    }

    public Object clone() {
        MailerModel m = (MailerModel)super.clone();
        m.changeListener = this.changeListener;
        return m;
    }

    public void notifyChangeListeners() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public List<String> getAddressList() {
        String addressees = this.getToAddress();
        ArrayList<String> addressList = new ArrayList<String>();
        if (addressees != null) {
            StringTokenizer next = new StringTokenizer(addressees, ",");
            while (next.hasMoreTokens()) {
                String theToken = next.nextToken().trim();
                if (theToken.indexOf("@") > 0) {
                    addressList.add(theToken);
                    continue;
                }
                log.warn("Ignored unexpected e-mail address: " + theToken);
            }
        }
        return addressList;
    }

    public void add(SampleResult sample) {
        this.add(sample, false);
    }

    public synchronized void add(SampleResult sample, boolean sendMails) {
        List<String> addressList;
        if (!sample.isSuccessful()) {
            ++this.failureCount;
            this.successCount = 0L;
        } else {
            ++this.successCount;
        }
        if (sendMails && this.failureCount > this.getFailureLimit() && !this.siteDown && !this.failureMsgSent && (addressList = this.getAddressList()).size() != 0) {
            try {
                this.sendMail(this.getFromAddress(), addressList, this.getFailureSubject(), "URL Failed: " + sample.getSampleLabel(), this.getSmtpHost());
            }
            catch (Exception e) {
                log.error("Problem sending mail: " + e);
            }
            this.siteDown = true;
            this.failureMsgSent = true;
            this.successCount = 0L;
            this.successMsgSent = false;
        }
        if (sendMails && this.siteDown && sample.getTime() != -1L && !this.successMsgSent && this.successCount > this.getSuccessLimit()) {
            addressList = this.getAddressList();
            try {
                this.sendMail(this.getFromAddress(), addressList, this.getSuccessSubject(), "URL Restarted: " + sample.getSampleLabel(), this.getSmtpHost());
            }
            catch (Exception e) {
                log.error("Problem sending mail", (Throwable)e);
            }
            this.siteDown = false;
            this.successMsgSent = true;
            this.failureCount = 0L;
            this.failureMsgSent = false;
        }
        if (this.successMsgSent && this.failureMsgSent) {
            this.clear();
        }
        this.notifyChangeListeners();
    }

    public synchronized void clear() {
        this.failureCount = 0L;
        this.successCount = 0L;
        this.siteDown = false;
        this.successMsgSent = false;
        this.failureMsgSent = false;
        this.notifyChangeListeners();
    }

    public String toString() {
        return "E-Mail Notification";
    }

    public void sendMail(String from, List<String> vEmails, String subject, String attText, String smtpHost) throws AddressException, MessagingException {
        String host = smtpHost;
        boolean debug = Boolean.valueOf(host);
        InternetAddress[] address = new InternetAddress[vEmails.size()];
        for (int k = 0; k < vEmails.size(); ++k) {
            address[k] = new InternetAddress(vEmails.get(k));
        }
        Properties props = new Properties();
        props.put(MAIL_SMTP_HOST, host);
        Session session = Session.getDefaultInstance((Properties)props, null);
        props = session.getProperties();
        if (!host.equalsIgnoreCase(props.getProperty(MAIL_SMTP_HOST))) {
            props.setProperty(MAIL_SMTP_HOST, host);
        }
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        msg.setSubject(subject);
        msg.setText(attText);
        Transport.send((Message)msg);
    }

    public synchronized void sendTestMail() throws AddressException, MessagingException {
        String to = this.getToAddress();
        String from = this.getFromAddress();
        String subject = "Testing mail-addresses";
        String smtpHost = this.getSmtpHost();
        String attText = "JMeter-Testmail\nTo:  " + to + "\n" + "From: " + from + "\n" + "Via:  " + smtpHost + "\n" + "Fail Subject:  " + this.getFailureSubject() + "\n" + "Success Subject:  " + this.getSuccessSubject();
        log.info(attText);
        this.sendMail(from, this.getAddressList(), subject, attText, smtpHost);
        log.info("Test mail sent successfully!!");
    }

    public void setToAddress(String str) {
        this.setProperty(TO_KEY, str);
    }

    public void setFromAddress(String str) {
        this.setProperty(FROM_KEY, str);
    }

    public void setSmtpHost(String str) {
        this.setProperty(HOST_KEY, str);
    }

    public void setFailureSubject(String str) {
        this.setProperty(FAILURE_SUBJECT, str);
    }

    public void setSuccessSubject(String str) {
        this.setProperty(SUCCESS_SUBJECT, str);
    }

    public void setSuccessLimit(String limit) {
        this.setProperty(SUCCESS_LIMIT_KEY, limit);
    }

    public void setFailureLimit(String limit) {
        this.setProperty(FAILURE_LIMIT_KEY, limit);
    }

    public String getToAddress() {
        return this.getPropertyAsString(TO_KEY);
    }

    public String getFromAddress() {
        return this.getPropertyAsString(FROM_KEY);
    }

    public String getSmtpHost() {
        return this.getPropertyAsString(HOST_KEY);
    }

    public String getFailureSubject() {
        return this.getPropertyAsString(FAILURE_SUBJECT);
    }

    public String getSuccessSubject() {
        return this.getPropertyAsString(SUCCESS_SUBJECT);
    }

    public long getSuccessLimit() {
        return this.getPropertyAsLong(SUCCESS_LIMIT_KEY);
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public long getFailureLimit() {
        return this.getPropertyAsLong(FAILURE_LIMIT_KEY);
    }

    public long getFailureCount() {
        return this.failureCount;
    }
}

