/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.ColorHelper;
import org.apache.jmeter.visualizers.GraphAccumListener;
import org.apache.jmeter.visualizers.GraphAccumModel;
import org.apache.jmeter.visualizers.GraphAccumVisualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GraphAccum
extends JComponent
implements Scrollable,
GraphAccumListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private GraphAccumModel model;
    private GraphAccumVisualizer visualizer;
    private boolean noLegendYet = true;
    private Point[] previousPts;
    private boolean previousPtsAlloc = false;
    protected static final int width = 2000;
    private static final int PLOT_X_WIDTH = 10;

    public GraphAccum() {
        log.debug("Start : GraphAnnum1");
        log.debug("End : GraphAnnum1");
    }

    public GraphAccum(GraphAccumModel model) {
        this();
        log.debug("Start : GraphAnnum2");
        this.setModel(model);
        log.debug("End : GraphAnnum2");
    }

    private void setModel(Object model) {
        log.debug("Start : setModel1");
        this.model = (GraphAccumModel)model;
        this.model.addGraphAccumListener(this);
        this.repaint();
        log.debug("End : setModel1");
    }

    public void setVisualizer(Object visualizer) {
        if (log.isDebugEnabled()) {
            log.debug("setVisualizer1 : Setting visualizer - " + visualizer);
        }
        this.visualizer = (GraphAccumVisualizer)visualizer;
    }

    public void setNoLegendYet(boolean value) {
        this.noLegendYet = value;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)((double)visibleRect.width * 0.9);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public boolean getNoLegendYet() {
        return this.noLegendYet;
    }

    public void updateGui() {
        log.debug("Start : updateGui1");
        this.repaint();
        log.debug("End : updateGui1");
    }

    public void updateGui(final SampleResult oneSample) {
        log.debug("Start : updateGui2");
        final int xPos = this.model.getSampleCount();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics g = GraphAccum.this.getGraphics();
                if (g != null) {
                    GraphAccum.this.drawSample(xPos * 10, oneSample, g);
                }
            }
        });
        log.debug("End : updateGui2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        log.debug("Start : paintComponent1");
        List<SampleResult> list = this.model.getList();
        synchronized (list) {
            this.previousPtsAlloc = false;
            Iterator<SampleResult> e = this.model.getList().iterator();
            int i = 0;
            while (e.hasNext()) {
                SampleResult s = e.next();
                this.drawSample(i * 10, s, g);
                ++i;
            }
        }
        log.debug("End : paintComponent1");
    }

    public void clearData() {
        this.setNoLegendYet(true);
        ((JPanel)this.visualizer.getWhiteCanvas()).removeAll();
        this.previousPts = null;
    }

    private void drawSample(int x, SampleResult oneSample, Graphics g) {
        log.debug("Start : drawSample1");
        int lastLevel = 0;
        int compCount = 0;
        SampleResult[] resultList = oneSample.getSubResults();
        int resultListCount = 0;
        if (!this.previousPtsAlloc) {
            this.previousPts = new Point[(resultListCount += resultList.length) + 2];
        }
        Color currColor = Color.black;
        JPanel lPanel = (JPanel)this.visualizer.getWhiteCanvas();
        JPanel legendPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        legendPanel.setLayout(gridBag);
        lPanel.add(legendPanel);
        Dimension d = this.getSize();
        long totalTime = oneSample.getTime();
        if (log.isDebugEnabled()) {
            log.debug("drawSample1 : total time - " + totalTime);
        }
        int data = (int)(totalTime * (long)d.height / this.model.getMax());
        g.setColor(currColor);
        if (!this.previousPtsAlloc) {
            g.drawLine(x % 2000, d.height - data, x % 2000, d.height - data - 1);
        } else {
            g.drawLine(this.previousPts[0].x % 2000, this.previousPts[0].y, x % 2000, d.height - data);
        }
        this.previousPts[0] = new Point(x % 2000, d.height - data);
        if (this.noLegendYet) {
            gbc.gridx = 0;
            gbc.gridy = compCount++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 10, 0, 0);
            JLabel totalTimeLabel = new JLabel("Total time - " + oneSample.toString());
            totalTimeLabel.setForeground(currColor);
            gridBag.setConstraints(totalTimeLabel, gbc);
            legendPanel.add(totalTimeLabel);
        }
        if (log.isDebugEnabled()) {
            log.debug("drawSample1 : main page load time - " + oneSample.getTime());
        }
        data = (int)(oneSample.getTime() * (long)d.height / this.model.getMax());
        currColor = ColorHelper.changeColorCyclicIncrement((Color)currColor, (int)40);
        g.setColor(currColor);
        if (!this.previousPtsAlloc) {
            g.drawLine(x % 2000, d.height - data, x % 2000, d.height - data - 1);
        } else {
            g.drawLine(this.previousPts[1].x % 2000, this.previousPts[1].y, x % 2000, d.height - data);
        }
        this.previousPts[1] = new Point(x % 2000, d.height - data);
        if (this.noLegendYet) {
            gbc.gridx = 0;
            gbc.gridy = compCount++;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 10, 0, 0);
            JLabel mainTimeLabel = new JLabel(oneSample.toString());
            mainTimeLabel.setForeground(currColor);
            gridBag.setConstraints(mainTimeLabel, gbc);
            legendPanel.add(mainTimeLabel);
        }
        lastLevel += data;
        int currPreviousPts = 2;
        if (resultList != null) {
            for (int i = 0; i < resultList.length; ++i) {
                SampleResult componentRes = resultList[i];
                if (log.isDebugEnabled()) {
                    log.debug("drawSample1 : componentRes - " + componentRes.getSampleLabel() + " loading time - " + componentRes.getTime());
                }
                data = (int)(componentRes.getTime() * (long)d.height / this.model.getMax());
                data += lastLevel;
                currColor = ColorHelper.changeColorCyclicIncrement((Color)currColor, (int)100);
                g.setColor(currColor);
                if (!this.previousPtsAlloc) {
                    g.drawLine(x % 2000, d.height - data, x % 2000, d.height - data - 1);
                } else {
                    g.drawLine(this.previousPts[currPreviousPts].x % 2000, this.previousPts[currPreviousPts].y, x % 2000, d.height - data);
                }
                this.previousPts[currPreviousPts++] = new Point(x % 2000, d.height - data);
                if (this.noLegendYet) {
                    gbc.gridx = 0;
                    gbc.gridy = compCount++;
                    gbc.anchor = 17;
                    gbc.weightx = 1.0;
                    gbc.insets = new Insets(0, 10, 0, 0);
                    JLabel compTimeLabel = new JLabel(componentRes.getSampleLabel());
                    compTimeLabel.setForeground(currColor);
                    gridBag.setConstraints(compTimeLabel, gbc);
                    legendPanel.add(compTimeLabel);
                }
                lastLevel = data;
            }
        }
        if (this.noLegendYet) {
            this.noLegendYet = false;
            lPanel.repaint();
            lPanel.revalidate();
        }
        if (!this.previousPtsAlloc) {
            this.previousPtsAlloc = true;
        }
        log.debug("End : drawSample1");
    }
}

