/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Message;
import org.apache.jmeter.protocol.jms.sampler.PlaceHolder;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MessageAdmin {
    private static final MessageAdmin SINGLETON = new MessageAdmin();
    private final Map<String, PlaceHolder> table = new ConcurrentHashMap<String, PlaceHolder>();
    private static final Logger log = LoggingManager.getLoggerForClass();

    private MessageAdmin() {
    }

    public static MessageAdmin getAdmin() {
        return SINGLETON;
    }

    public void putRequest(String id, Message request) {
        if (log.isDebugEnabled()) {
            log.debug("REQ_ID [" + id + "]");
        }
        this.table.put(id, new PlaceHolder(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putReply(String id, Message reply) {
        PlaceHolder holder = this.table.get(id);
        if (log.isDebugEnabled()) {
            log.debug("RPL_ID [" + id + "] for holder " + holder);
        }
        if (holder != null) {
            Object obj;
            holder.setReply(reply);
            Object object = obj = holder.getRequest();
            synchronized (object) {
                obj.notify();
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Failed to match reply: " + reply);
        }
    }

    public Message get(String id) {
        PlaceHolder holder = this.table.remove(id);
        if (log.isDebugEnabled()) {
            log.debug("GET_ID [" + id + "] for " + holder);
        }
        if (holder == null || !holder.hasReply()) {
            log.debug("Message with " + id + " not found.");
        }
        return holder == null ? null : (Message)holder.getReply();
    }
}

