/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.report.gui.action.AbstractAction;
import org.apache.jmeter.report.gui.tree.ReportTreeListener;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDragNDrop
extends AbstractAction {
    public static final String ADD = "drag_n_drop.add";
    public static final String INSERT_BEFORE = "drag_n_drop.insert_before";
    public static final String INSERT_AFTER = "drag_n_drop.insert_after";
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        ReportGuiPackage guiPackage = ReportGuiPackage.getInstance();
        ReportTreeNode[] draggedNodes = guiPackage.getTreeListener().getDraggedNodes();
        ReportTreeListener treeListener = guiPackage.getTreeListener();
        ReportTreeNode currentNode = treeListener.getCurrentNode();
        ReportTreeNode parentNode = (ReportTreeNode)currentNode.getParent();
        TestElement te = currentNode.getTestElement();
        if (te instanceof TestPlan || te instanceof WorkBench) {
            parentNode = null;
        }
        if (ADD.equals(action) && ReportDragNDrop.canAddTo(currentNode)) {
            this.removeNodesFromParents(draggedNodes);
            for (int i = 0; i < draggedNodes.length; ++i) {
                ReportGuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], currentNode, currentNode.getChildCount());
            }
        } else if (INSERT_BEFORE.equals(action) && ReportDragNDrop.canAddTo(parentNode)) {
            this.removeNodesFromParents(draggedNodes);
            for (int i = 0; i < draggedNodes.length; ++i) {
                int index = parentNode.getIndex(currentNode);
                ReportGuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], parentNode, index);
            }
        } else if (INSERT_AFTER.equals(action) && ReportDragNDrop.canAddTo(parentNode)) {
            this.removeNodesFromParents(draggedNodes);
            for (int i = 0; i < draggedNodes.length; ++i) {
                int index = parentNode.getIndex(currentNode) + 1;
                ReportGuiPackage.getInstance().getTreeModel().insertNodeInto(draggedNodes[i], parentNode, index);
            }
        }
        ReportGuiPackage.getInstance().getMainFrame().repaint();
    }

    static boolean canAddTo(ReportTreeNode parentNode) {
        if (null == parentNode) {
            return false;
        }
        TestElement te = parentNode.getTestElement();
        if (te instanceof Controller) {
            return true;
        }
        if (te instanceof Sampler) {
            return true;
        }
        if (te instanceof WorkBench) {
            return true;
        }
        return te instanceof TestPlan;
    }

    protected void removeNodesFromParents(ReportTreeNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ReportGuiPackage.getInstance().getTreeModel().removeNodeFromParent(nodes[i]);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add(ADD);
        commands.add(INSERT_BEFORE);
        commands.add(INSERT_AFTER);
    }
}

