/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.swing.HtmlPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportHelp
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String HELP = "help";
    private static final Set<String> commands = new HashSet<String>();
    public static final String HELP_DOCS = "file:///" + JMeterUtils.getJMeterHome() + "/printable_docs/usermanual/";
    public static final String HELP_PAGE = HELP_DOCS + "component_reference.html";
    public static final String HELP_FUNCTIONS = HELP_DOCS + "functions.html";
    private static JDialog helpWindow;
    private static HtmlPane helpDoc;
    private static JScrollPane scroller;
    private static String currentPage;

    public void doAction(ActionEvent e) {
        if (helpWindow == null) {
            helpWindow = new JDialog(new Frame(), JMeterUtils.getResString((String)HELP), false);
            helpWindow.getContentPane().setLayout(new GridLayout(1, 1));
            ComponentUtil.centerComponentInWindow((Component)helpWindow, (int)60);
        }
        helpWindow.getContentPane().removeAll();
        helpWindow.getContentPane().add(scroller);
        helpWindow.setVisible(true);
        if (e.getSource() instanceof String[]) {
            String[] source = (String[])e.getSource();
            this.resetPage(source[0]);
            helpDoc.scrollToReference(source[1]);
        } else {
            this.resetPage(HELP_PAGE);
            helpDoc.scrollToReference(ReportGuiPackage.getInstance().getTreeListener().getCurrentNode().getDocAnchor());
        }
    }

    private void resetPage(String source) {
        if (!currentPage.equals(source)) {
            try {
                helpDoc.setPage(source);
                currentPage = source;
            }
            catch (IOException err) {
                log.error(err.toString());
                JMeterUtils.reportErrorToUser((String)"Problem loading a help page - see log for details");
                currentPage = "";
            }
        }
    }

    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add(HELP);
        helpDoc = new HtmlPane();
        scroller = new JScrollPane((Component)helpDoc);
        helpDoc.setEditable(false);
        try {
            helpDoc.setPage(HELP_PAGE);
            currentPage = HELP_PAGE;
        }
        catch (IOException err) {
            String msg = "Couldn't load help file " + err.toString();
            log.error(msg);
            currentPage = "";
        }
    }
}

