/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.testelement.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportRemove
implements Command {
    private static final Set<String> commands = new HashSet<String>();

    public Set<String> getActionNames() {
        return commands;
    }

    public void doAction(ActionEvent e) {
        ReportActionRouter.getInstance().actionPerformed(new ActionEvent(e.getSource(), e.getID(), "check_remove"));
        ReportGuiPackage guiPackage = ReportGuiPackage.getInstance();
        ReportTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
        TreePath newTreePath = guiPackage.getTreeListener().removedSelectedNode();
        for (int i = nodes.length - 1; i >= 0; --i) {
            ReportRemove.removeNode(nodes[i]);
        }
        guiPackage.getTreeListener().getJTree().setSelectionPath(newTreePath);
        guiPackage.updateCurrentGui();
    }

    public static void removeNode(ReportTreeNode node) {
        TestElement testElement = node.getTestElement();
        if (testElement.canRemove()) {
            ReportGuiPackage.getInstance().getTreeModel().removeNodeFromParent(node);
            ReportGuiPackage.getInstance().removeNode(testElement);
        } else {
            String message = testElement.getClass().getName() + " is busy";
            JOptionPane.showMessageDialog(null, message, "Cannot remove item", 0);
        }
    }

    static {
        commands.add("remove");
    }
}

