/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class LoopControlPanel
extends AbstractControllerGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JCheckBox infinite;
    private JTextField loops;
    private boolean displayName = true;
    private static final String INFINITE = "Infinite Field";
    private static final String LOOPS = "Loops Field";

    public LoopControlPanel() {
        this(true);
    }

    public LoopControlPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
        this.setState(1);
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof LoopController) {
            this.setState(((LoopController)element).getLoopString());
        } else {
            this.setState(1);
        }
    }

    public TestElement createTestElement() {
        LoopController lc = new LoopController();
        this.modifyTestElement(lc);
        return lc;
    }

    public void modifyTestElement(TestElement lc) {
        this.configureTestElement(lc);
        if (lc instanceof LoopController) {
            if (this.loops.getText().length() > 0) {
                ((LoopController)lc).setLoops(this.loops.getText());
            } else {
                ((LoopController)lc).setLoops(-1);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.loops.setText("1");
        this.infinite.setSelected(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.infinite.isSelected()) {
            this.loops.setText("");
            this.loops.setEnabled(false);
        } else {
            this.loops.setEnabled(true);
            new FocusRequester(this.loops);
        }
    }

    public String getLabelResource() {
        return "loop_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createLoopCountPanel(), "North");
            this.add((Component)mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createLoopCountPanel(), "North");
        }
    }

    private JPanel createLoopCountPanel() {
        JPanel loopPanel = new JPanel(new BorderLayout(5, 0));
        JLabel loopsLabel = new JLabel(JMeterUtils.getResString("iterator_num"));
        loopPanel.add((Component)loopsLabel, "West");
        JPanel loopSubPanel = new JPanel(new BorderLayout(5, 0));
        this.loops = new JTextField("1", 5);
        this.loops.setName(LOOPS);
        loopsLabel.setLabelFor(this.loops);
        loopSubPanel.add((Component)this.loops, "Center");
        this.infinite = new JCheckBox(JMeterUtils.getResString("infinite"));
        this.infinite.setActionCommand(INFINITE);
        this.infinite.addActionListener(this);
        loopSubPanel.add((Component)this.infinite, "West");
        loopPanel.add((Component)loopSubPanel, "Center");
        loopPanel.add(Box.createHorizontalStrut(loopsLabel.getPreferredSize().width + this.loops.getPreferredSize().width + this.infinite.getPreferredSize().width), "North");
        return loopPanel;
    }

    private void setState(String loopCount) {
        if (loopCount.startsWith("-")) {
            this.setState(-1);
        } else {
            this.loops.setText(loopCount);
            this.infinite.setSelected(false);
            this.loops.setEnabled(true);
        }
    }

    private void setState(int loopCount) {
        if (loopCount <= -1) {
            this.infinite.setSelected(true);
            this.loops.setEnabled(false);
            this.loops.setText("");
        } else {
            this.infinite.setSelected(false);
            this.loops.setEnabled(true);
            this.loops.setText(Integer.toString(loopCount));
        }
    }
}

