/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Help;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.reflect.ClassFinder;

public class FunctionHelper
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 240L;
    private JLabeledChoice functionList;
    private ArgumentsPanel parameterPanel;
    private JLabeledTextField cutPasteFunction;
    private final Map<String, Class<?>> functionMap = new HashMap();
    private JButton generateButton;

    public FunctionHelper() {
        super((Frame)null, JMeterUtils.getResString("function_helper_title"), false);
        this.init();
    }

    private void init() {
        this.parameterPanel = new ArgumentsPanel(JMeterUtils.getResString("function_params"), false);
        this.initializeFunctionList();
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel comboPanel = new JPanel(new FlowLayout(1));
        comboPanel.add((Component)this.functionList);
        JButton helpButton = new JButton(JMeterUtils.getResString("help"));
        helpButton.addActionListener(new HelpListener());
        comboPanel.add(helpButton);
        this.getContentPane().add((Component)comboPanel, "North");
        this.getContentPane().add((Component)this.parameterPanel, "Center");
        JPanel resultsPanel = new JPanel(new FlowLayout(1));
        this.cutPasteFunction = new JLabeledTextField(JMeterUtils.getResString("cut_paste_function"), 35);
        resultsPanel.add((Component)this.cutPasteFunction);
        this.generateButton = new JButton(JMeterUtils.getResString("generate"));
        this.generateButton.addActionListener(this);
        resultsPanel.add(this.generateButton);
        this.getContentPane().add((Component)resultsPanel, "South");
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    private void initializeFunctionList() {
        try {
            List functionClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{Function.class}, (boolean)true);
            String[] functionNames = new String[functionClasses.size()];
            int count = 0;
            for (String clazz : functionClasses) {
                Class<?> cl = Class.forName(clazz);
                functionNames[count] = ((Function)cl.newInstance()).getReferenceKey();
                this.functionMap.put(functionNames[count], cl);
                ++count;
            }
            this.functionList = new JLabeledChoice(JMeterUtils.getResString("choose_function"), functionNames);
            this.functionList.addChangeListener((ChangeListener)this);
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void stateChanged(ChangeEvent event) {
        try {
            Arguments args = new Arguments();
            Function function = (Function)this.functionMap.get(this.functionList.getText()).newInstance();
            List<String> argumentDesc = function.getArgumentDesc();
            for (String help : argumentDesc) {
                args.addArgument(help, "");
            }
            this.parameterPanel.configure(args);
            this.parameterPanel.revalidate();
            this.getContentPane().remove(this.parameterPanel);
            this.pack();
            this.getContentPane().add((Component)this.parameterPanel, "Center");
            this.pack();
            this.validate();
            this.repaint();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        StringBuilder functionCall = new StringBuilder("${");
        functionCall.append(this.functionList.getText());
        Arguments args = (Arguments)this.parameterPanel.createTestElement();
        if (args.getArguments().size() > 0) {
            functionCall.append("(");
            PropertyIterator iter = args.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                Argument arg = (Argument)iter.next().getObjectValue();
                if (!first) {
                    functionCall.append(",");
                }
                functionCall.append(arg.getValue());
                first = false;
            }
            functionCall.append(")");
        }
        functionCall.append("}");
        this.cutPasteFunction.setText(functionCall.toString());
    }

    private class HelpListener
    implements ActionListener {
        private HelpListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String[] source = new String[]{Help.HELP_FUNCTIONS, FunctionHelper.this.functionList.getText()};
            ActionEvent helpEvent = new ActionEvent(source, e.getID(), "help");
            ActionRouter.getInstance().actionPerformed(helpEvent);
        }
    }
}

