/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RunningSample;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class Summariser
extends AbstractTestElement
implements Serializable,
SampleListener,
TestListener,
NoThreadClone,
Remoteable {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long INTERVAL = JMeterUtils.getPropDefault("summariser.interval", 180);
    private static final boolean TOLOG = JMeterUtils.getPropDefault("summariser.log", true);
    private static final boolean TOOUT = JMeterUtils.getPropDefault("summariser.out", true);
    private static final int INTERVAL_WINDOW = 5;
    private static final Object lock = new Object();
    private static final Map<String, Totals> accumulators = new ConcurrentHashMap<String, Totals>();
    private static int instanceCount;
    private transient Totals myTotals = null;
    private transient String myName;
    private static final DecimalFormat dfDouble;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Summariser() {
        Object object = lock;
        synchronized (object) {
            accumulators.clear();
            instanceCount = 0;
        }
    }

    public Summariser(String name) {
        this();
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sampleOccurred(SampleEvent e) {
        SampleResult s = e.getResult();
        long now = System.currentTimeMillis() / 1000L;
        RunningSample myDelta = null;
        RunningSample myTotal = null;
        boolean reportNow = false;
        Totals totals = this.myTotals;
        synchronized (totals) {
            if (s != null) {
                this.myTotals.delta.addSample(s);
            }
            if (now > this.myTotals.last + 5L && now % INTERVAL <= 5L) {
                reportNow = true;
                myDelta = new RunningSample(this.myTotals.delta);
                this.myTotals.moveDelta();
                myTotal = new RunningSample(this.myTotals.total);
                this.myTotals.last = now;
            }
        }
        if (reportNow) {
            String str = this.format(this.myName, myDelta, "+");
            if (TOLOG) {
                log.info(str);
            }
            if (TOOUT) {
                System.out.println(str);
            }
            if (myTotal != null && myDelta != null && myTotal.getNumSamples() != myDelta.getNumSamples()) {
                str = this.format(this.myName, myTotal, "=");
                if (TOLOG) {
                    log.info(str);
                }
                if (TOOUT) {
                    System.out.println(str);
                }
            }
        }
    }

    private static StringBuilder longToSb(StringBuilder sb, long l, int len) {
        sb.setLength(0);
        sb.append(l);
        return JOrphanUtils.rightAlign((StringBuilder)sb, (int)len);
    }

    private static StringBuilder doubleToSb(StringBuilder sb, double d, int len, int frac) {
        sb.setLength(0);
        dfDouble.setMinimumFractionDigits(frac);
        dfDouble.setMaximumFractionDigits(frac);
        sb.append(dfDouble.format(d));
        return JOrphanUtils.rightAlign((StringBuilder)sb, (int)len);
    }

    private String format(String name, RunningSample s, String type) {
        StringBuilder tmp = new StringBuilder(20);
        StringBuilder sb = new StringBuilder(100);
        sb.append(name);
        sb.append(" ");
        sb.append(type);
        sb.append(" ");
        sb.append((CharSequence)Summariser.longToSb(tmp, s.getNumSamples(), 5));
        sb.append(" in ");
        long elapsed = s.getElapsed();
        sb.append((CharSequence)Summariser.doubleToSb(tmp, (double)elapsed / 1000.0, 5, 1));
        sb.append("s = ");
        if (elapsed > 0L) {
            sb.append((CharSequence)Summariser.doubleToSb(tmp, s.getRate(), 6, 1));
        } else {
            sb.append("******");
        }
        sb.append("/s Avg: ");
        sb.append((CharSequence)Summariser.longToSb(tmp, s.getAverage(), 5));
        sb.append(" Min: ");
        sb.append((CharSequence)Summariser.longToSb(tmp, s.getMin(), 5));
        sb.append(" Max: ");
        sb.append((CharSequence)Summariser.longToSb(tmp, s.getMax(), 5));
        sb.append(" Err: ");
        sb.append((CharSequence)Summariser.longToSb(tmp, s.getErrorCount(), 5));
        sb.append(" (");
        sb.append(s.getErrorPercentageString());
        sb.append(")");
        return sb.toString();
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void testStarted() {
        this.testStarted("local");
    }

    public void testEnded() {
        this.testEnded("local");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(String host) {
        Object object = lock;
        synchronized (object) {
            this.myName = this.getName();
            this.myTotals = accumulators.get(this.myName);
            if (this.myTotals == null) {
                this.myTotals = new Totals();
                accumulators.put(this.myName, this.myTotals);
            }
            ++instanceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String host) {
        Set<Map.Entry<String, Totals>> totals = null;
        Object object = lock;
        synchronized (object) {
            if (--instanceCount <= 0) {
                totals = accumulators.entrySet();
            }
        }
        if (totals == null) {
            return;
        }
        for (Map.Entry<String, Totals> entry : totals) {
            String str;
            String name = entry.getKey();
            Totals total = entry.getValue();
            if (total.delta.getNumSamples() > 0L && total.total.getNumSamples() > 0L) {
                str = this.format(name, total.delta, "+");
                if (TOLOG) {
                    log.info(str);
                }
                if (TOOUT) {
                    System.out.println(str);
                }
            }
            total.moveDelta();
            str = this.format(name, total.total, "=");
            if (TOLOG) {
                log.info(str);
            }
            if (!TOOUT) continue;
            System.out.println(str);
        }
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    static {
        dfDouble = new DecimalFormat("#0.0");
    }

    private static class Totals {
        private long last = 0L;
        private final RunningSample delta = new RunningSample("DELTA", 0);
        private final RunningSample total = new RunningSample("TOTAL", 0);

        private Totals() {
        }

        private void moveDelta() {
            this.total.addSample(this.delta);
            this.delta.clear();
        }
    }
}

