/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.testbeans.gui.ComboStringEditor;
import org.apache.jmeter.testbeans.gui.GenericTestBeanCustomizer;
import org.apache.jmeter.testbeans.gui.WrapperEditor;

public class FileEditor
implements PropertyEditor,
ActionListener {
    private final JPanel panel;
    private final PropertyEditor editor;

    @Deprecated
    public FileEditor() throws IntrospectionException {
        this(new PropertyDescriptor("dummy", null, null));
    }

    public FileEditor(PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("Descriptor must not be null");
        }
        JButton button = new JButton("Browse...");
        button.addActionListener(this);
        boolean notNull = GenericTestBeanCustomizer.notNull(descriptor);
        boolean notExpression = GenericTestBeanCustomizer.notExpression(descriptor);
        boolean notOther = GenericTestBeanCustomizer.notOther(descriptor);
        Object defaultValue = descriptor.getValue("default");
        ComboStringEditor cse = new ComboStringEditor();
        cse.setNoUndefined(notNull);
        cse.setNoEdit(notExpression && notOther);
        this.editor = new WrapperEditor(this, new SimpleFileEditor(), cse, !notNull, !notExpression, !notOther, defaultValue);
        this.panel = new JPanel(new BorderLayout(5, 0));
        this.panel.add(this.editor.getCustomEditor(), "Center");
        this.panel.add((Component)button, "East");
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = FileDialoger.promptToOpenFile();
        if (chooser == null) {
            return;
        }
        this.setValue(chooser.getSelectedFile().getPath());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.editor.addPropertyChangeListener(listener);
    }

    public String getAsText() {
        return this.editor.getAsText();
    }

    public Component getCustomEditor() {
        return this.panel;
    }

    public String getJavaInitializationString() {
        return this.editor.getJavaInitializationString();
    }

    public String[] getTags() {
        return this.editor.getTags();
    }

    public Object getValue() {
        return this.editor.getValue();
    }

    public boolean isPaintable() {
        return this.editor.isPaintable();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        this.editor.paintValue(gfx, box);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.editor.removePropertyChangeListener(listener);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.editor.setAsText(text);
    }

    public void setValue(Object value) {
        this.editor.setValue(value);
    }

    public boolean supportsCustomEditor() {
        return this.editor.supportsCustomEditor();
    }

    private static class SimpleFileEditor
    extends PropertyEditorSupport {
        private SimpleFileEditor() {
        }

        public String getAsText() {
            Object value = super.getValue();
            if (value instanceof File) {
                return ((File)value).getPath();
            }
            return (String)value;
        }

        public void setAsText(String text) throws IllegalArgumentException {
            super.setValue(new File(text));
        }

        public Object getValue() {
            return super.getValue();
        }

        public void setValue(Object file) {
            super.setValue(file);
        }
    }
}

