/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BeanShellServer
implements Runnable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final int serverport;
    private final String serverfile;

    public BeanShellServer(int port, String file) {
        this.serverfile = file;
        this.serverport = port;
    }

    static String getprop(String s) {
        return JMeterUtils.getPropDefault(s, s);
    }

    static void setprop(String s, String v) {
        JMeterUtils.getJMeterProperties().setProperty(s, v);
    }

    public void run() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Method eval;
            Object instance;
            block6: {
                Class<?> Interpreter = loader.loadClass("bsh.Interpreter");
                instance = Interpreter.newInstance();
                Class<String> string = String.class;
                Class<Object> object = Object.class;
                eval = Interpreter.getMethod("eval", string);
                Method setObj = Interpreter.getMethod("set", string, object);
                Method setInt = Interpreter.getMethod("set", string, Integer.TYPE);
                Method source = Interpreter.getMethod("source", string);
                setObj.invoke(instance, "t", this);
                setInt.invoke(instance, "portnum", this.serverport);
                if (this.serverfile.length() > 0) {
                    try {
                        source.invoke(instance, this.serverfile);
                    }
                    catch (InvocationTargetException e1) {
                        log.warn("Could not source " + this.serverfile);
                        Throwable t = e1.getCause();
                        if (t == null) break block6;
                        log.warn(t.toString());
                    }
                }
            }
            eval.invoke(instance, "setAccessibility(true);");
            eval.invoke(instance, "server(portnum);");
        }
        catch (ClassNotFoundException e) {
            log.error("Beanshell Interpreter not found");
        }
        catch (Exception e) {
            log.error("Problem starting BeanShell server ", (Throwable)e);
        }
    }
}

