/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util.accesslog;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.util.accesslog.Generator;
import org.apache.jmeter.protocol.http.util.accesslog.NVPair;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class StandardGenerator
implements Generator,
Serializable {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected HTTPSamplerBase SAMPLE = null;
    protected transient FileWriter WRITER = null;
    protected transient OutputStream OUTPUT = null;
    protected String FILENAME = null;
    protected File FILE = null;

    public StandardGenerator() {
        this.init();
    }

    public StandardGenerator(String file) {
        this.FILENAME = file;
        this.init();
    }

    private void init() {
        this.generateRequest();
    }

    protected void initStream() {
        try {
            this.OUTPUT = new FileOutputStream(this.FILE);
        }
        catch (IOException exception) {
            log.error(exception.getMessage());
        }
    }

    public void close() {
        JOrphanUtils.closeQuietly((Closeable)this.OUTPUT);
        JOrphanUtils.closeQuietly((Closeable)this.WRITER);
    }

    public void setHost(String host) {
        this.SAMPLE.setDomain(host);
    }

    public void setLabel(String label) {
    }

    public void setMethod(String post_get) {
        this.SAMPLE.setMethod(post_get);
    }

    public void setParams(NVPair[] params) {
        for (int idx = 0; idx < params.length; ++idx) {
            this.SAMPLE.addArgument(params[idx].getName(), params[idx].getValue());
        }
    }

    public void setPath(String path) {
        this.SAMPLE.setPath(path);
    }

    public void setPort(int port) {
        this.SAMPLE.setPort(port);
    }

    public void setQueryString(String querystring) {
        this.SAMPLE.parseArguments(querystring);
    }

    public void setSourceLogs(String sourcefile) {
    }

    public void setTarget(Object target) {
    }

    public Object generateRequest() {
        this.SAMPLE = HTTPSamplerFactory.newInstance();
        return this.SAMPLE;
    }

    public void save() {
    }

    public void reset() {
        this.SAMPLE = null;
        this.generateRequest();
    }
}

