/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.system;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.protocol.system.StreamGobbler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeCommand {
    private StreamGobbler outputGobbler;
    private final File directory;
    private final Map<String, String> env;
    private Map<String, String> executionEnvironment;

    public NativeCommand(File directory, Map<String, String> env) {
        this.directory = directory;
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(List<String> arguments) throws InterruptedException, IOException {
        Process proc = null;
        try {
            ProcessBuilder procBuild = new ProcessBuilder(arguments);
            procBuild.environment().putAll(this.env);
            this.executionEnvironment = Collections.unmodifiableMap(procBuild.environment());
            procBuild.directory(this.directory);
            procBuild.redirectErrorStream(true);
            proc = procBuild.start();
            this.outputGobbler = new StreamGobbler(proc.getInputStream());
            this.outputGobbler.start();
            int exitVal = proc.waitFor();
            this.outputGobbler.join();
            int n = exitVal;
            return n;
        }
        finally {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public String getOutResult() {
        if (this.outputGobbler != null) {
            return this.outputGobbler.getResult();
        }
        return "";
    }

    public Map<String, String> getExecutionEnvironment() {
        return this.executionEnvironment;
    }
}

