/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.system.NativeCommand;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SystemSampler
extends AbstractSampler {
    private static final long serialVersionUID = 1L;
    public static final String COMMAND = "SystemSampler.command";
    public static final String DIRECTORY = "SystemSampler.directory";
    public static final String ARGUMENTS = "SystemSampler.arguments";
    public static final String ENVIRONMENT = "SystemSampler.environment";
    public static final String CHECK_RETURN_CODE = "SystemSampler.checkReturnCode";
    public static final String EXPECTED_RETURN_CODE = "SystemSampler.expectedReturnCode";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    public static final int DEFAULT_RETURN_CODE = 0;

    public SampleResult sample(Entry entry) {
        SampleResult results = new SampleResult();
        results.setDataType("text");
        try {
            String command = this.getCommand();
            Arguments args = this.getArguments();
            Arguments environment = this.getEnvironmentVariables();
            boolean checkReturnCode = this.getCheckReturnCode();
            int expectedReturnCode = this.getExpectedReturnCode();
            ArrayList<String> cmds = new ArrayList<String>(args.getArgumentCount() + 1);
            StringBuilder cmdLine = new StringBuilder(null == command ? "" : command);
            cmds.add(command);
            for (int i = 0; i < args.getArgumentCount(); ++i) {
                Argument arg = args.getArgument(i);
                cmds.add(arg.getPropertyAsString("Argument.value"));
                cmdLine.append(" ");
                cmdLine.append((String)cmds.get(i + 1));
            }
            HashMap<String, String> env = new HashMap<String, String>();
            for (int i = 0; i < environment.getArgumentCount(); ++i) {
                Argument arg = environment.getArgument(i);
                env.put(arg.getName(), arg.getPropertyAsString("Argument.value"));
            }
            File directory = null;
            if (StringUtils.isEmpty((String)this.getDirectory())) {
                directory = new File(FileServer.getDefaultBase());
                if (log.isDebugEnabled()) {
                    log.debug("Using default directory:" + directory.getAbsolutePath());
                }
            } else {
                directory = new File(this.getDirectory());
                if (log.isDebugEnabled()) {
                    log.debug("Using configured directory:" + directory.getAbsolutePath());
                }
            }
            results.setSamplerData("Working Directory:" + directory.getAbsolutePath() + ", Environment:" + env + ", Executing:" + cmdLine.toString());
            NativeCommand nativeCommand = new NativeCommand(directory, env);
            String responseData = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Will run :" + cmdLine + " using working directory:" + directory.getAbsolutePath() + " with environment:" + env);
                }
                results.sampleStart();
                int returnCode = nativeCommand.run(cmds);
                if (log.isDebugEnabled()) {
                    log.debug("Ran :" + cmdLine + " using working directory:" + directory.getAbsolutePath() + " with execution environment:" + nativeCommand.getExecutionEnvironment());
                }
                results.sampleEnd();
                if (checkReturnCode && returnCode != expectedReturnCode) {
                    results.setSuccessful(false);
                    responseData = "System did not return expected return code.  Expected [" + expectedReturnCode + "]. Returned [" + returnCode + "].";
                    results.setSampleLabel("FAILED: " + this.getName());
                } else {
                    results.setSuccessful(true);
                    responseData = "System Call Complete.";
                    results.setSampleLabel(this.getName());
                }
            }
            catch (IOException ioe) {
                results.setSuccessful(false);
                responseData = "Exception occured whilst executing System Call: " + ioe;
                results.setSampleLabel("ERROR: " + this.getName());
            }
            catch (InterruptedException ie) {
                results.setSuccessful(false);
                responseData = "System Sampler Interupted whilst executing System Call: " + ie;
                results.setSampleLabel("ERROR: " + this.getName());
            }
            results.setResponseData((responseData + "\nProcess Output:\n" + nativeCommand.getOutResult()).getBytes());
        }
        catch (Exception e) {
            results.setSuccessful(false);
            results.setResponseData(("Unknown Exception caught: " + e).getBytes());
            results.setSampleLabel("ERROR: " + this.getName());
        }
        return results;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }

    public String getDirectory() {
        return this.getPropertyAsString(DIRECTORY, FileServer.getDefaultBase());
    }

    public void setDirectory(String directory) {
        this.setProperty(DIRECTORY, directory, FileServer.getDefaultBase());
    }

    public void setCommand(String command) {
        this.setProperty(COMMAND, command);
    }

    public String getCommand() {
        return this.getPropertyAsString(COMMAND);
    }

    public void setArguments(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)args));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setCheckReturnCode(boolean checkit) {
        this.setProperty(CHECK_RETURN_CODE, checkit);
    }

    public boolean getCheckReturnCode() {
        return this.getPropertyAsBoolean(CHECK_RETURN_CODE);
    }

    public void setExpectedReturnCode(int code) {
        this.setProperty(EXPECTED_RETURN_CODE, Integer.toString(code));
    }

    public int getExpectedReturnCode() {
        return this.getPropertyAsInt(EXPECTED_RETURN_CODE);
    }

    public void setEnvironmentVariables(Arguments arguments) {
        this.setProperty((JMeterProperty)new TestElementProperty(ENVIRONMENT, (TestElement)arguments));
    }

    public Arguments getEnvironmentVariables() {
        return (Arguments)this.getProperty(ENVIRONMENT).getObjectValue();
    }
}

