/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.MenuInfo;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportMenuFactory {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String TIMERS = "menu_timer";
    public static final String CONTROLLERS = "menu_logic_controller";
    public static final String CONFIG_ELEMENTS = "menu_config_element";
    public static final String POST_PROCESSORS = "menu_post_processors";
    public static final String PRE_PROCESSORS = "menu_pre_processors";
    public static final String NON_TEST_ELEMENTS = "menu_non_test_elements";
    public static final String LISTENERS = "menu_listener";
    public static final String REPORT_PAGE = "menu_report_page";
    public static final String TABLES = "menu_tables";
    private static final Map<String, List<MenuInfo>> menuMap = new HashMap<String, List<MenuInfo>>();
    private static final Set<String> elementsToSkip = new HashSet<String>();
    private static final String[] MENU_ADD_CONTROLLER = new String[]{"menu_logic_controller", "menu_config_element", "menu_timer", "menu_listener", "menu_pre_processors", "menu_post_processors"};
    private static final String[] MENU_PARENT_CONTROLLER = new String[]{"menu_logic_controller"};
    private static List<MenuInfo> controllers;
    private static List<MenuInfo> configElements;
    private static List<MenuInfo> listeners;
    private static List<MenuInfo> nonTestElements;
    private static List<MenuInfo> postProcessors;
    private static List<MenuInfo> preProcessors;
    private static List<MenuInfo> reportPage;
    private static List<MenuInfo> tables;

    private ReportMenuFactory() {
    }

    public static void addEditMenu(JPopupMenu menu, boolean removable) {
        ReportMenuFactory.addSeparator(menu);
        if (removable) {
            menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"remove"), "Remove", "remove", KeyStrokes.REMOVE));
        }
        menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"cut"), "Cut", "Cut", KeyStrokes.CUT));
        menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"copy"), "Copy", "Copy", KeyStrokes.COPY));
        menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"paste"), "Paste", "Paste", KeyStrokes.PASTE));
        menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"paste_insert"), "Paste Insert", "Paste Insert"));
    }

    public static void addFileMenu(JPopupMenu menu) {
        ReportMenuFactory.addSeparator(menu);
        menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"open"), "Open", "open"));
        menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"save_as"), "Save As", "save_as"));
        JMenuItem savePicture = ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"save_as_image"), "Save Image", "save_graphics", KeyStrokes.SAVE_GRAPHICS);
        menu.add(savePicture);
        if (!(ReportGuiPackage.getInstance().getCurrentGui() instanceof Printable)) {
            savePicture.setEnabled(false);
        }
        JMenuItem disabled = ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"disable"), "Disable", "disable");
        JMenuItem enabled = ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"enable"), "Enable", "enable");
        boolean isEnabled = ReportGuiPackage.getInstance().getTreeListener().getCurrentNode().isEnabled();
        if (isEnabled) {
            disabled.setEnabled(true);
            enabled.setEnabled(false);
        } else {
            disabled.setEnabled(false);
            enabled.setEnabled(true);
        }
        menu.add(enabled);
        menu.add(disabled);
        ReportMenuFactory.addSeparator(menu);
        menu.add(ReportMenuFactory.makeMenuItem(JMeterUtils.getResString((String)"help"), "Help", "help"));
    }

    public static JMenu makeMenus(String[] categories, String label, String actionCommand) {
        JMenu addMenu = new JMenu(label);
        for (int i = 0; i < categories.length; ++i) {
            addMenu.add(ReportMenuFactory.makeMenu(categories[i], actionCommand));
        }
        return addMenu;
    }

    public static JPopupMenu getDefaultControllerMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus((String[])MENU_ADD_CONTROLLER, (String)JMeterUtils.getResString((String)"add"), (String)"Add"));
        pop.add(ReportMenuFactory.makeMenus(MENU_PARENT_CONTROLLER, JMeterUtils.getResString((String)"insert_parent"), "Add Parent"));
        MenuFactory.addEditMenu((JPopupMenu)pop, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)pop);
        return pop;
    }

    public static JPopupMenu getDefaultConfigElementMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu((JPopupMenu)pop, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)pop);
        return pop;
    }

    public static JPopupMenu getDefaultVisualizerMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu((JPopupMenu)pop, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)pop);
        return pop;
    }

    public static JPopupMenu getDefaultTimerMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu((JPopupMenu)pop, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)pop);
        return pop;
    }

    public static JPopupMenu getDefaultAssertionMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu((JPopupMenu)pop, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)pop);
        return pop;
    }

    public static JPopupMenu getDefaultExtractorMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu((JPopupMenu)pop, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)pop);
        return pop;
    }

    public static JMenu makeMenu(String category, String actionCommand) {
        return ReportMenuFactory.makeMenu((Collection<MenuInfo>)menuMap.get(category), actionCommand, JMeterUtils.getResString((String)category));
    }

    public static JMenu makeMenu(Collection<MenuInfo> menuInfo, String actionCommand, String menuName) {
        Iterator<MenuInfo> iter = menuInfo.iterator();
        JMenu menu = new JMenu(menuName);
        while (iter.hasNext()) {
            MenuInfo info = iter.next();
            menu.add(ReportMenuFactory.makeMenuItem(info.getLabel(), info.getClassName(), actionCommand));
        }
        return menu;
    }

    public static void setEnabled(JMenu menu) {
        if (menu.getSubElements().length == 0) {
            menu.setEnabled(false);
        }
    }

    public static JMenuItem makeMenuItem(String label, String name, String actionCommand) {
        JMenuItem newMenuChoice = new JMenuItem(label);
        newMenuChoice.setName(name);
        newMenuChoice.addActionListener(ReportActionRouter.getInstance());
        if (actionCommand != null) {
            newMenuChoice.setActionCommand(actionCommand);
        }
        return newMenuChoice;
    }

    public static JMenuItem makeMenuItem(String label, String name, String actionCommand, KeyStroke accel) {
        JMenuItem item = ReportMenuFactory.makeMenuItem(label, name, actionCommand);
        item.setAccelerator(accel);
        return item;
    }

    private static void initializeMenus() {
        try {
            List guiClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{JMeterGUIComponent.class, TestBean.class});
            controllers = new LinkedList<MenuInfo>();
            configElements = new LinkedList<MenuInfo>();
            listeners = new LinkedList<MenuInfo>();
            postProcessors = new LinkedList<MenuInfo>();
            preProcessors = new LinkedList<MenuInfo>();
            tables = new LinkedList<MenuInfo>();
            reportPage = new LinkedList<MenuInfo>();
            nonTestElements = new LinkedList<MenuInfo>();
            menuMap.put(CONFIG_ELEMENTS, configElements);
            menuMap.put(CONTROLLERS, controllers);
            menuMap.put(LISTENERS, listeners);
            menuMap.put(NON_TEST_ELEMENTS, nonTestElements);
            menuMap.put(POST_PROCESSORS, postProcessors);
            menuMap.put(PRE_PROCESSORS, preProcessors);
            menuMap.put(REPORT_PAGE, reportPage);
            menuMap.put(TABLES, tables);
            Collections.sort(guiClasses);
            for (String name : guiClasses) {
                Object item;
                if (name.endsWith("JMeterTreeNode") || name.endsWith("TestBeanGUI")) continue;
                try {
                    Class<?> c = Class.forName(name);
                    item = TestBean.class.isAssignableFrom(c) ? new TestBeanGUI(c) : (JMeterGUIComponent)c.newInstance();
                }
                catch (NoClassDefFoundError e) {
                    log.warn("Missing jar? Could not create " + name + ". " + e);
                    continue;
                }
                catch (Exception e) {
                    log.warn("Could not instantiate " + name, (Throwable)e);
                    continue;
                }
                if (elementsToSkip.contains(name) || elementsToSkip.contains(item.getStaticLabel())) {
                    log.info("Skipping " + name);
                    continue;
                }
                elementsToSkip.add(name);
                Collection categories = item.getMenuCategories();
                if (categories == null) {
                    log.debug(name + " participates in no menus.");
                    continue;
                }
                if (categories.contains(POST_PROCESSORS)) {
                    postProcessors.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(PRE_PROCESSORS)) {
                    preProcessors.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(CONTROLLERS)) {
                    controllers.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(NON_TEST_ELEMENTS)) {
                    nonTestElements.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(LISTENERS)) {
                    listeners.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(CONFIG_ELEMENTS)) {
                    configElements.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (categories.contains(TABLES)) {
                    tables.add(new MenuInfo(item.getStaticLabel(), name));
                }
                if (!categories.contains(REPORT_PAGE)) continue;
                reportPage.add(new MenuInfo(item.getStaticLabel(), name));
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    private static void addSeparator(JPopupMenu menu) {
        MenuElement[] elements = menu.getSubElements();
        if (elements.length > 0 && !(elements[elements.length - 1] instanceof JPopupMenu.Separator)) {
            menu.addSeparator();
        }
    }

    static {
        try {
            String[] classesToSkip = JOrphanUtils.split((String)JMeterUtils.getPropDefault((String)"not_in_menu", (String)""), (String)",");
            for (int i = 0; i < classesToSkip.length; ++i) {
                elementsToSkip.add(classesToSkip[i].trim());
            }
            ReportMenuFactory.initializeMenus();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

