/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAddToTree
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private Map<String, String> allJMeterComponentCommands = new HashMap<String, String>();

    public ReportAddToTree() {
        this.allJMeterComponentCommands.put("Add", "Add");
    }

    public Set<String> getActionNames() {
        return this.allJMeterComponentCommands.keySet();
    }

    public void doAction(ActionEvent e) {
        try {
            TestElement node = ReportGuiPackage.getInstance().createTestElement(((JComponent)e.getSource()).getName());
            this.addObjectToTree(node);
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
        }
    }

    protected void addObjectToTree(TestElement el) {
        ReportGuiPackage guiPackage = ReportGuiPackage.getInstance();
        ReportTreeNode node = new ReportTreeNode(el, guiPackage.getTreeModel());
        guiPackage.getTreeModel().insertNodeInto(node, guiPackage.getTreeListener().getCurrentNode(), guiPackage.getTreeListener().getCurrentNode().getChildCount());
        TestElement curNode = (TestElement)guiPackage.getTreeListener().getCurrentNode().getUserObject();
        if (curNode != null) {
            curNode.addTestElement(el);
            guiPackage.getMainFrame().getTree().setSelectionPath(new TreePath(node.getPath()));
        }
    }
}

