/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JFileChooser;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.ReportFileDialoger;
import org.apache.jmeter.report.gui.action.ReportActionRouter;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportSave
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String SAVE_ALL_AS = "save_all_as";
    public static final String SAVE_AS = "save_as";
    public static final String SAVE = "save";
    private static final Set<String> commands = new HashSet<String>();

    public Set<String> getActionNames() {
        return commands;
    }

    public void doAction(ActionEvent e) throws IllegalUserActionException {
        HashTree subTree = null;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        subTree = e.getActionCommand().equals(SAVE_AS) ? ReportGuiPackage.getInstance().getCurrentSubTree() : ReportGuiPackage.getInstance().getTreeModel().getReportPlan();
        String updateFile = ReportGuiPackage.getInstance().getReportPlanFile();
        if (!SAVE.equals(e.getActionCommand()) || updateFile == null) {
            JFileChooser chooser = ReportFileDialoger.promptToSaveFile(ReportGuiPackage.getInstance().getTreeListener().getCurrentNode().getName() + ".jmr");
            if (chooser == null) {
                return;
            }
            updateFile = chooser.getSelectedFile().getAbsolutePath();
            if (!e.getActionCommand().equals(SAVE_AS)) {
                ReportGuiPackage.getInstance().setReportPlanFile(updateFile);
            }
        }
        ReportActionRouter.getInstance().doActionNow(new ActionEvent(subTree, e.getID(), "sub_tree_saved"));
        try {
            this.convertSubTree(subTree);
        }
        catch (Exception err) {
            // empty catch block
        }
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(updateFile);
            SaveService.saveTree((HashTree)subTree, (OutputStream)ostream);
            log.info("saveTree");
        }
        catch (Exception ex) {
            try {
                ReportGuiPackage.getInstance().setReportPlanFile(null);
                log.error("", (Throwable)ex);
                throw new IllegalUserActionException("Couldn't save test plan to file: " + updateFile);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(ostream);
                throw throwable;
            }
        }
        JOrphanUtils.closeQuietly((Closeable)ostream);
    }

    private void convertSubTree(HashTree tree) {
        for (ReportTreeNode item : new LinkedList(tree.list())) {
            this.convertSubTree(tree.getTree((Object)item));
            TestElement testElement = item.getTestElement();
            tree.replace((Object)item, (Object)testElement);
        }
    }

    static {
        commands.add(SAVE_AS);
        commands.add(SAVE_ALL_AS);
        commands.add(SAVE);
    }
}

