/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterException;
import org.apache.log.Logger;

public class BeanShellPreProcessor
extends BeanShellTestElement
implements Cloneable,
PreProcessor,
TestBean {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 4L;
    private static final String INIT_FILE = "beanshell.preprocessor.init";

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public void process() {
        BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
        if (bshInterpreter == null) {
            log.error("BeanShell not found");
            return;
        }
        JMeterContext jmctx = JMeterContextService.getContext();
        Sampler sam = jmctx.getCurrentSampler();
        try {
            bshInterpreter.set("sampler", (Object)sam);
            this.processFileOrScript(bshInterpreter);
        }
        catch (JMeterException e) {
            log.warn("Problem in BeanShell script " + (Object)((Object)e));
        }
    }
}

