/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.RemoteJMeterEngine;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RemoteJMeterEngineImpl
extends UnicastRemoteObject
implements RemoteJMeterEngine {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    static final String JMETER_ENGINE_RMI_NAME = "JMeterEngine";
    private transient JMeterEngine backingEngine;
    private transient Thread ownerThread;
    private static final int DEFAULT_RMI_PORT = JMeterUtils.getPropDefault("server.rmi.port", 1099);
    private static final int DEFAULT_LOCAL_PORT = JMeterUtils.getPropDefault("server.rmi.localport", 0);
    private static final boolean createServer;
    private final Object LOCK = new Object();
    private final int rmiPort;
    private Properties remotelySetProperties;

    private RemoteJMeterEngineImpl(int localPort, int rmiPort) throws RemoteException {
        super(localPort);
        this.rmiPort = rmiPort;
        System.out.println("Created remote object: " + this.getRef().remoteToString());
    }

    public static void startServer(int rmiPort) throws RemoteException {
        RemoteJMeterEngineImpl engine = new RemoteJMeterEngineImpl(DEFAULT_LOCAL_PORT, rmiPort == 0 ? DEFAULT_RMI_PORT : rmiPort);
        engine.init();
    }

    private void init() throws RemoteException {
        log.info("Starting backing engine on " + this.rmiPort);
        InetAddress localHost = null;
        String host = System.getProperties().getProperty("java.rmi.server.hostname");
        try {
            localHost = host == null ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        }
        catch (UnknownHostException e1) {
            throw new RemoteException("Cannot start. Unable to get local host IP address.");
        }
        log.info("IP address=" + localHost.getHostAddress());
        String hostName = localHost.getHostName();
        if (localHost.isLoopbackAddress() && host == null) {
            throw new RemoteException("Cannot start. " + hostName + " is a loopback address.");
        }
        if (localHost.isSiteLocalAddress()) {
            log.info("IP address is a site-local address; this may cause problems with remote access.\n\tCan be overridden by defining the system property 'java.rmi.server.hostname' - see jmeter-server script file");
        }
        log.debug("This = " + this);
        if (createServer) {
            log.info("Creating RMI registry (server.rmi.create=true)");
            try {
                LocateRegistry.createRegistry(this.rmiPort);
            }
            catch (RemoteException e) {
                String msg = "Problem creating registry: " + e;
                log.warn(msg);
                System.err.println(msg);
                System.err.println("Continuing...");
            }
        }
        try {
            Registry reg = LocateRegistry.getRegistry(this.rmiPort);
            reg.rebind(JMETER_ENGINE_RMI_NAME, this);
            log.info("Bound to registry on port " + this.rmiPort);
        }
        catch (Exception ex) {
            log.error("rmiregistry needs to be running to start JMeter in server mode\n\t" + ex.toString());
            throw new RemoteException("Cannot start. See server log file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rconfigure(HashTree testTree, String host, File jmxBase, String scriptName) throws RemoteException {
        log.info("Creating JMeter engine on host " + host + " base '" + jmxBase + "'");
        Object object = this.LOCK;
        synchronized (object) {
            if (this.backingEngine != null && this.backingEngine.isActive()) {
                log.warn("Engine is busy - cannot create JMeter engine");
                throw new IllegalStateException("Engine is busy - please try later");
            }
            this.ownerThread = Thread.currentThread();
            this.backingEngine = new StandardJMeterEngine(host);
            this.backingEngine.configure(testTree);
        }
        FileServer.getFileServer().setScriptName(scriptName);
        FileServer.getFileServer().setBase(jmxBase);
    }

    public void rrunTest() throws RemoteException, JMeterEngineException, IllegalStateException {
        log.info("Running test");
        this.checkOwner("runTest");
        this.backingEngine.runTest();
    }

    public void rreset() throws RemoteException, IllegalStateException {
        if (this.backingEngine != null) {
            log.info("Reset");
            this.checkOwner("reset");
            this.backingEngine.reset();
        } else {
            log.warn("Backing engine is null, ignoring reset");
        }
    }

    public void rstopTest(boolean now) throws RemoteException {
        if (now) {
            log.info("Stopping test ...");
        } else {
            log.info("Shutting test ...");
        }
        this.backingEngine.stopTest(now);
        log.info("... stopped");
    }

    public void rexit() throws RemoteException {
        log.info("Exitting");
        this.backingEngine.exit();
        Registry reg = LocateRegistry.getRegistry(this.rmiPort);
        try {
            reg.unbind(JMETER_ENGINE_RMI_NAME);
        }
        catch (NotBoundException e) {
            log.warn("JMeterEngine is not bound", (Throwable)e);
        }
        log.info("Unbound from registry");
        System.gc();
        System.runFinalization();
    }

    public void rsetProperties(Properties p) throws RemoteException, IllegalStateException {
        this.checkOwner("setProperties");
        if (this.remotelySetProperties != null) {
            Properties jmeterProperties = JMeterUtils.getJMeterProperties();
            log.info("Cleaning previously set properties " + this.remotelySetProperties);
            for (String string : this.remotelySetProperties.keySet()) {
                jmeterProperties.remove(string);
            }
        }
        this.backingEngine.setProperties(p);
        this.remotelySetProperties = p;
    }

    private void checkOwner(String methodName) throws IllegalStateException {
        if (this.ownerThread != null && this.ownerThread != Thread.currentThread()) {
            String msg = "The engine is not owned by this thread - cannot call " + methodName;
            log.warn(msg);
            throw new IllegalStateException(msg);
        }
    }

    static {
        if (DEFAULT_LOCAL_PORT != 0) {
            System.out.println("Using local port: " + DEFAULT_LOCAL_PORT);
        }
        createServer = JMeterUtils.getPropDefault("server.rmi.create", true);
    }
}

