/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Map;
import org.apache.jmeter.engine.util.AbstractTransformer;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.StringUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoVariableReplacement
extends AbstractTransformer {
    public UndoVariableReplacement(CompoundVariable masterFunction, Map<String, String> variables) {
        this.setMasterFunction(masterFunction);
        this.setVariables(variables);
    }

    @Override
    public JMeterProperty transformValue(JMeterProperty prop) throws InvalidVariableException {
        String input = prop.getStringValue();
        for (Map.Entry<String, String> entry : this.getVariables().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            input = StringUtilities.substitute(input, "${" + key + "}", value);
        }
        StringProperty newProp = new StringProperty(prop.getName(), input);
        return newProp;
    }
}

