/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.apache.jmeter.gui.CommentPanel;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractJMeterGuiComponent
extends JPanel
implements JMeterGUIComponent,
Printable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private boolean enabled = true;
    protected NamePanel namePanel = new NamePanel();
    private CommentPanel commentPanel = new CommentPanel();

    public AbstractJMeterGuiComponent() {
        this.initGui();
    }

    public void setName(String name) {
        this.namePanel.setName(name);
    }

    public void setComment(String comment) {
        this.commentPanel.setText(comment);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        log.debug("Setting enabled: " + e);
        this.enabled = e;
    }

    public String getName() {
        if (this.getNamePanel() != null) {
            return this.getNamePanel().getName();
        }
        return "";
    }

    public String getComment() {
        if (this.getCommentPanel() != null) {
            return this.getCommentPanel().getText();
        }
        return "";
    }

    protected NamePanel getNamePanel() {
        return this.namePanel;
    }

    private CommentPanel getCommentPanel() {
        return this.commentPanel;
    }

    protected Component createTitleLabel() {
        JLabel titleLabel = new JLabel(this.getStaticLabel());
        Font curFont = titleLabel.getFont();
        titleLabel.setFont(curFont.deriveFont((float)curFont.getSize() + 4.0f));
        return titleLabel;
    }

    public void configure(TestElement element) {
        this.setName(element.getName());
        this.enabled = element.getProperty("TestElement.enabled") instanceof NullProperty ? true : element.getPropertyAsBoolean("TestElement.enabled");
        this.getCommentPanel().setText(element.getComment());
    }

    public void clearGui() {
        this.initGui();
        this.enabled = true;
    }

    private void initGui() {
        this.setName(this.getStaticLabel());
        this.commentPanel.clearGui();
    }

    protected void configureTestElement(TestElement mc) {
        mc.setName(this.getName());
        mc.setProperty(new StringProperty("TestElement.gui_class", this.getClass().getName()));
        mc.setProperty(new StringProperty("TestElement.test_class", mc.getClass().getName()));
        log.debug("setting element to enabled: " + this.enabled);
        mc.setProperty(new BooleanProperty("TestElement.enabled", this.enabled));
        mc.setComment(this.getComment());
    }

    protected Container makeTitlePanel() {
        VerticalPanel titlePanel = new VerticalPanel();
        titlePanel.add(this.createTitleLabel());
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.setBorder(BorderFactory.createEtchedBorder());
        contentPanel.add(this.getNamePanel());
        contentPanel.add(this.getCommentPanel());
        titlePanel.add(contentPanel);
        return titlePanel;
    }

    protected Border makeBorder() {
        return BorderFactory.createEmptyBorder(10, 10, 5, 10);
    }

    protected JScrollPane makeScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    protected JScrollPane makeScrollPane(Component comp, int verticalPolicy, int horizontalPolicy) {
        JScrollPane pane = new JScrollPane(comp, verticalPolicy, horizontalPolicy);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString(this.getLabelResource());
    }

    public String getDocAnchor() {
        String label = JMeterUtils.getResString(this.getLabelResource(), new Locale("", ""));
        return label.replace(' ', '_');
    }

    public JComponent getPrintableComponent() {
        return this;
    }
}

