/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JPasswordField;

public class PasswordEditor
extends PropertyEditorSupport
implements ActionListener,
FocusListener {
    private JPasswordField textField = new JPasswordField();
    private String initialValue = "";

    protected PasswordEditor() {
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
    }

    public String getAsText() {
        return new String(this.textField.getPassword());
    }

    public void setAsText(String value) {
        this.initialValue = value;
        this.textField.setText(value);
    }

    public Object getValue() {
        return this.getAsText();
    }

    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.setAsText((String)value);
    }

    public Component getCustomEditor() {
        return this.textField;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void firePropertyChange() {
        String newValue = this.getAsText();
        if (this.initialValue.equals(newValue)) {
            return;
        }
        this.initialValue = newValue;
        super.firePropertyChange();
    }

    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.firePropertyChange();
    }
}

