/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.jmeter.testbeans.gui.TestBeanPropertyEditor;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditor
extends PropertyEditorSupport
implements FocusListener,
TestBeanPropertyEditor,
TableModelListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String CLASSNAME = "tableObject.classname";
    public static final String HEADERS = "table.headers";
    public static final String OBJECT_PROPERTIES = "tableObject.properties";
    private JTable table;
    private ObjectTableModel model;
    private Class<?> clazz;
    private PropertyDescriptor descriptor;
    private final JButton addButton = new JButton(JMeterUtils.getResString("add"));
    private final JButton removeButton;
    private final JButton clearButton;

    public TableEditor() {
        this.addButton.addActionListener(new AddListener());
        this.removeButton = new JButton(JMeterUtils.getResString("remove"));
        this.removeButton.addActionListener(new RemoveListener());
        this.clearButton = new JButton(JMeterUtils.getResString("clear"));
        this.clearButton.addActionListener(new ClearListener());
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        JComponent pane = this.makePanel();
        pane.doLayout();
        pane.validate();
        return pane;
    }

    private JComponent makePanel() {
        JPanel p = new JPanel(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.setPreferredSize(scroller.getMinimumSize());
        p.add((Component)scroller, "Center");
        JPanel south = new JPanel();
        south.add(this.addButton);
        south.add(this.removeButton);
        south.add(this.clearButton);
        p.add((Component)south, "South");
        return p;
    }

    @Override
    public Object getValue() {
        return this.model.getObjectList();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.model.setRows(this.convertCollection((Collection)value));
        } else {
            this.model.clearData();
        }
        this.firePropertyChange();
    }

    private Collection<Object> convertCollection(Collection<?> values) {
        LinkedList<Object> l = new LinkedList<Object>();
        for (Object obj : values) {
            if (obj instanceof TestElementProperty) {
                l.add(((TestElementProperty)obj).getElement());
                continue;
            }
            l.add(obj);
        }
        return l;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setDescriptor(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
        String value = (String)descriptor.getValue(CLASSNAME);
        if (value == null) {
            throw new RuntimeException("The Table Editor requires the CLASSNAME atttribute be set - the name of the object to represent a row");
        }
        try {
            this.clazz = Class.forName(value);
            this.initializeModel();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find the CLASSNAME class " + value, e);
        }
    }

    void initializeModel() {
        Object hdrs = this.descriptor.getValue(HEADERS);
        if (!(hdrs instanceof String[])) {
            throw new RuntimeException("attribute HEADERS must be a String array");
        }
        if (this.clazz == String.class) {
            this.model = new ObjectTableModel((String[])hdrs, new Functor[0], new Functor[0], new Class[]{String.class});
        } else {
            Object value = this.descriptor.getValue(OBJECT_PROPERTIES);
            if (!(value instanceof String[])) {
                throw new RuntimeException("attribute OBJECT_PROPERTIES must be a String array");
            }
            String[] props = (String[])value;
            Functor[] writers = new Functor[props.length];
            Functor[] readers = new Functor[props.length];
            Class[] editors = new Class[props.length];
            int count = 0;
            for (String propName : props) {
                propName = propName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propName.substring(1);
                writers[count] = this.createWriter(this.clazz, propName);
                readers[count] = this.createReader(this.clazz, propName);
                editors[count] = this.getArgForWriter(this.clazz, propName);
                ++count;
            }
            this.model = new ObjectTableModel((String[])hdrs, readers, writers, editors);
        }
        this.model.addTableModelListener((TableModelListener)this);
        this.table = new JTable((TableModel)this.model);
        this.table.setSelectionMode(0);
        this.table.addFocusListener(this);
    }

    Functor createWriter(Class<?> c, String propName) {
        String setter = "set" + propName;
        return new Functor(setter);
    }

    Functor createReader(Class<?> c, String propName) {
        String getter = "get" + propName;
        try {
            c.getMethod(getter, new Class[0]);
            return new Functor(getter);
        }
        catch (Exception e) {
            return new Functor("is" + propName);
        }
    }

    Class<?> getArgForWriter(Class<?> c, String propName) {
        String setter = "set" + propName;
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(setter)) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.firePropertyChange();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        int editingRow = this.table.getEditingRow();
        int editingColumn = this.table.getEditingColumn();
        TableCellEditor ce = null;
        if (editingRow != -1 && editingColumn != -1) {
            ce = this.table.getCellEditor(editingRow, editingColumn);
        }
        Component editor = this.table.getEditorComponent();
        if (ce != null && (editor == null || editor != e.getOppositeComponent())) {
            ce.stopCellEditing();
        } else if (editor != null) {
            editor.addFocusListener(this);
        }
        this.firePropertyChange();
    }

    private class ClearListener
    implements ActionListener {
        private ClearListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TableEditor.this.model.clearData();
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int row = TableEditor.this.table.getSelectedRow();
            if (row >= 0) {
                TableEditor.this.model.removeRow(row);
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TableEditor.this.model.addRow(TableEditor.this.clazz.newInstance());
            }
            catch (Exception err) {
                log.error("The class type given to TableEditor was not instantiable. ", (Throwable)err);
            }
        }
    }
}

