/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterThread;

public abstract class AbstractThreadGroup
extends AbstractTestElement
implements Serializable,
Controller {
    private static final long serialVersionUID = 240L;
    public static final String ON_SAMPLE_ERROR = "ThreadGroup.on_sample_error";
    public static final String ON_SAMPLE_ERROR_CONTINUE = "continue";
    public static final String ON_SAMPLE_ERROR_START_NEXT_LOOP = "startnextloop";
    public static final String ON_SAMPLE_ERROR_STOPTHREAD = "stopthread";
    public static final String ON_SAMPLE_ERROR_STOPTEST = "stoptest";
    public static final String ON_SAMPLE_ERROR_STOPTEST_NOW = "stoptestnow";
    public static final String NUM_THREADS = "ThreadGroup.num_threads";
    public static final String MAIN_CONTROLLER = "ThreadGroup.main_controller";
    private int numberOfThreads = 0;

    public boolean isDone() {
        return this.getSamplerController().isDone();
    }

    public Sampler next() {
        return this.getSamplerController().next();
    }

    public Controller getSamplerController() {
        Controller c = (Controller)this.getProperty(MAIN_CONTROLLER).getObjectValue();
        return c;
    }

    public void setSamplerController(LoopController c) {
        c.setContinueForever(false);
        this.setProperty(new TestElementProperty(MAIN_CONTROLLER, c));
    }

    public void addTestElement(TestElement child) {
        this.getSamplerController().addTestElement(child);
    }

    public void addIterationListener(LoopIterationListener lis) {
        this.getSamplerController().addIterationListener(lis);
    }

    public void removeIterationListener(LoopIterationListener iterationListener) {
        this.getSamplerController().removeIterationListener(iterationListener);
    }

    public void initialize() {
        Controller c = this.getSamplerController();
        JMeterProperty property = c.getProperty("TestElement.name");
        property.setObjectValue(this.getName());
        property.setRunningVersion(property.isRunningVersion());
        c.initialize();
    }

    public void startNextLoop() {
        ((LoopController)this.getSamplerController()).startNextLoop();
    }

    public void triggerEndOfLoop() {
    }

    public void setNumThreads(int numThreads) {
        this.setProperty(new IntegerProperty(NUM_THREADS, numThreads));
    }

    synchronized void incrNumberOfThreads() {
        ++this.numberOfThreads;
    }

    synchronized void decrNumberOfThreads() {
        --this.numberOfThreads;
    }

    public synchronized int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getNumThreads() {
        return this.getPropertyAsInt(NUM_THREADS);
    }

    public boolean getOnErrorStartNextLoop() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_START_NEXT_LOOP);
    }

    public boolean getOnErrorStopThread() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTHREAD);
    }

    public boolean getOnErrorStopTest() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTEST);
    }

    public boolean getOnErrorStopTestNow() {
        return this.getPropertyAsString(ON_SAMPLE_ERROR).equalsIgnoreCase(ON_SAMPLE_ERROR_STOPTEST_NOW);
    }

    public abstract void scheduleThread(JMeterThread var1);
}

