/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterThread;

public class ThreadGroup
extends AbstractThreadGroup {
    private static final long serialVersionUID = 240L;
    public static final String RAMP_TIME = "ThreadGroup.ramp_time";
    public static final String SCHEDULER = "ThreadGroup.scheduler";
    public static final String START_TIME = "ThreadGroup.start_time";
    public static final String END_TIME = "ThreadGroup.end_time";
    public static final String DURATION = "ThreadGroup.duration";
    public static final String DELAY = "ThreadGroup.delay";

    public void setScheduler(boolean Scheduler) {
        this.setProperty(new BooleanProperty(SCHEDULER, Scheduler));
    }

    public boolean getScheduler() {
        return this.getPropertyAsBoolean(SCHEDULER);
    }

    public void setStartTime(long stime) {
        this.setProperty(new LongProperty(START_TIME, stime));
    }

    public long getStartTime() {
        return this.getPropertyAsLong(START_TIME);
    }

    public long getDuration() {
        return this.getPropertyAsLong(DURATION);
    }

    public void setDuration(long duration) {
        this.setProperty(new LongProperty(DURATION, duration));
    }

    public long getDelay() {
        return this.getPropertyAsLong(DELAY);
    }

    public void setDelay(long delay) {
        this.setProperty(new LongProperty(DELAY, delay));
    }

    public void setEndTime(long etime) {
        this.setProperty(new LongProperty(END_TIME, etime));
    }

    public long getEndTime() {
        return this.getPropertyAsLong(END_TIME);
    }

    public void setRampUp(int rampUp) {
        this.setProperty(new IntegerProperty(RAMP_TIME, rampUp));
    }

    public int getRampUp() {
        return this.getPropertyAsInt(RAMP_TIME);
    }

    public void scheduleThread(JMeterThread thread) {
        int rampUp = this.getRampUp();
        float perThreadDelay = (float)(rampUp * 1000) / (float)this.getNumThreads();
        thread.setInitialDelay((int)(perThreadDelay * (float)thread.getThreadNum()));
        this.scheduleThread(thread, this);
    }

    private void scheduleThread(JMeterThread thread, ThreadGroup group) {
        if (group.getScheduler()) {
            long now = System.currentTimeMillis();
            if (group.getDelay() > 0L) {
                thread.setStartTime(group.getDelay() * 1000L + now);
            } else {
                long start = group.getStartTime();
                if (start < now) {
                    start = now;
                }
                thread.setStartTime(start);
            }
            if (group.getDuration() > 0L) {
                thread.setEndTime(group.getDuration() * 1000L + thread.getStartTime());
            } else {
                thread.setEndTime(group.getEndTime());
            }
            thread.setScheduled(true);
        }
    }
}

