/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterVersion;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.test.UnitTestManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterUtils
implements UnitTestManager {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String EXPERT_MODE_PROPERTY = "jmeter.expertMode";
    private static final String ENGLISH_LANGUAGE = Locale.ENGLISH.getLanguage();
    private static volatile Properties appProperties;
    private static final Vector<LocaleChangeListener> localeChangeListeners;
    private static volatile Locale locale;
    private static volatile ResourceBundle resources;
    private static String localHostIP;
    private static String localHostName;
    private static String localHostFullName;
    private static volatile boolean ignoreResorces;
    private static final ThreadLocal<Perl5Matcher> localMatcher;
    private static final Random rand;
    public static final String RES_KEY_PFX = "[res_key=";
    private static String jmDir;
    private static String jmBin;

    public static Perl5Matcher getMatcher() {
        return localMatcher.get();
    }

    public static Properties getProperties(String file) {
        JMeterUtils.loadJMeterProperties(file);
        JMeterUtils.initLogging();
        JMeterUtils.initLocale();
        return appProperties;
    }

    public static void initLogging() {
        LoggingManager.initializeLogging((Properties)appProperties);
    }

    public static void initLocale() {
        String loc = appProperties.getProperty("language");
        if (loc != null) {
            String[] parts = JOrphanUtils.split((String)loc, (String)"_");
            if (parts.length == 2) {
                JMeterUtils.setLocale(new Locale(parts[0], parts[1]));
            } else {
                JMeterUtils.setLocale(new Locale(loc, ""));
            }
        } else {
            JMeterUtils.setLocale(Locale.getDefault());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJMeterProperties(String file) {
        Properties p = new Properties(System.getProperties());
        InputStream is = null;
        try {
            File f = new File(file);
            is = new FileInputStream(f);
            p.load(is);
        }
        catch (IOException e) {
            try {
                try {
                    is = ClassLoader.getSystemResourceAsStream("org/apache/jmeter/jmeter.properties");
                    if (is == null) {
                        throw new RuntimeException("Could not read JMeter properties file");
                    }
                    p.load(is);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(is);
                throw throwable;
            }
            JOrphanUtils.closeQuietly((Closeable)is);
        }
        JOrphanUtils.closeQuietly((Closeable)is);
        appProperties = p;
    }

    public static Properties loadProperties(String file) {
        return JMeterUtils.loadProperties(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadProperties(String file, Properties defaultProps) {
        Properties p = new Properties(defaultProps);
        InputStream is = null;
        try {
            File f = new File(file);
            is = new FileInputStream(f);
            p.load(is);
        }
        catch (IOException e) {
            block10: {
                URL resource;
                block9: {
                    resource = JMeterUtils.class.getClassLoader().getResource(file);
                    if (resource != null) break block9;
                    log.warn("Cannot find " + file);
                    Properties properties = defaultProps;
                    JOrphanUtils.closeQuietly((Closeable)is);
                    return properties;
                }
                is = resource.openStream();
                if (is != null) break block10;
                log.warn("Cannot open " + file);
                Properties properties = defaultProps;
                JOrphanUtils.closeQuietly((Closeable)is);
                return properties;
            }
            try {
                p.load(is);
                {
                    catch (IOException ex) {
                        log.warn("Error reading " + file + " " + ex.toString());
                        Properties properties = defaultProps;
                        JOrphanUtils.closeQuietly((Closeable)is);
                        return properties;
                    }
                }
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(is);
                throw throwable;
            }
            JOrphanUtils.closeQuietly((Closeable)is);
        }
        JOrphanUtils.closeQuietly((Closeable)is);
        return p;
    }

    public static PatternCacheLRU getPatternCache() {
        return LazyPatternCacheHolder.INSTANCE;
    }

    public static Pattern getPattern(String expression) throws MalformedCachePatternException {
        return JMeterUtils.getPattern(expression, 32768);
    }

    public static Pattern getPattern(String expression, int options) throws MalformedCachePatternException {
        return LazyPatternCacheHolder.INSTANCE.getPattern(expression, options);
    }

    public void initializeProperties(String file) {
        System.out.println("Initializing Properties: " + file);
        JMeterUtils.getProperties(file);
    }

    public static List<String> findClassesThatExtend(Class<?> superClass) throws IOException {
        return ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{superClass}, (boolean)false);
    }

    public static String[] getSearchPaths() {
        String p = JMeterUtils.getPropDefault("search_paths", null);
        String[] result = new String[1];
        if (p != null) {
            String[] paths = p.split(";");
            result = new String[paths.length + 1];
            for (int i = 1; i < result.length; ++i) {
                result[i] = paths[i - 1];
            }
        }
        result[0] = JMeterUtils.getJMeterHome() + "/lib/ext";
        return result;
    }

    public static int getRandomInt(int r) {
        return rand.nextInt(r);
    }

    public static void setLocale(Locale loc) {
        log.info("Setting Locale to " + loc.toString());
        Locale def = null;
        boolean isDefault = false;
        if (loc.getLanguage().equals(ENGLISH_LANGUAGE)) {
            isDefault = true;
            def = Locale.getDefault();
            if (!def.getLanguage().equals(ENGLISH_LANGUAGE)) {
                Locale.setDefault(Locale.ENGLISH);
            } else {
                def = null;
            }
        }
        if (loc.toString().equals("ignoreResources")) {
            log.warn("Resource bundles will be ignored");
            ignoreResorces = true;
        } else {
            ResourceBundle resBund;
            ignoreResorces = false;
            resources = resBund = ResourceBundle.getBundle("org.apache.jmeter.resources.messages", loc);
            locale = loc;
            Locale resBundLocale = resBund.getLocale();
            if (!isDefault && !resBundLocale.equals(loc)) {
                if (resBundLocale.getLanguage().equals(loc.getLanguage())) {
                    log.info("Could not find resources for '" + loc.toString() + "', using '" + resBundLocale.toString() + "'");
                } else {
                    log.error("Could not find resources for '" + loc.toString() + "'");
                }
            }
        }
        JMeterUtils.notifyLocaleChangeListeners();
        if (def != null) {
            Locale.setDefault(def);
        }
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void addLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.add(listener);
    }

    public static void removeLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.remove(listener);
    }

    private static void notifyLocaleChangeListeners() {
        LocaleChangeEvent event = new LocaleChangeEvent(JMeterUtils.class, locale);
        Vector listeners = (Vector)localeChangeListeners.clone();
        for (LocaleChangeListener listener : listeners) {
            listener.localeChanged(event);
        }
    }

    public static String getResString(String key) {
        return JMeterUtils.getResStringDefault(key, RES_KEY_PFX + key + "]");
    }

    public static String getResString(String key, Locale forcedLocale) {
        return JMeterUtils.getResStringDefault(key, RES_KEY_PFX + key + "]", forcedLocale);
    }

    @Deprecated
    public static String getResString(String key, String defaultValue) {
        return JMeterUtils.getResStringDefault(key, defaultValue);
    }

    private static String getResStringDefault(String key, String defaultValue) {
        return JMeterUtils.getResStringDefault(key, defaultValue, null);
    }

    private static String getResStringDefault(String key, String defaultValue, Locale forcedLocale) {
        if (key == null) {
            return null;
        }
        String resKey = key.replace(' ', '_');
        resKey = resKey.toLowerCase(Locale.ENGLISH);
        String resString = null;
        try {
            ResourceBundle bundle = resources;
            if (forcedLocale != null) {
                bundle = ResourceBundle.getBundle("org.apache.jmeter.resources.messages", forcedLocale);
            }
            resString = bundle.getString(resKey);
            if (ignoreResorces) {
                return "[" + key + "]";
            }
        }
        catch (MissingResourceException mre) {
            if (ignoreResorces) {
                return "[?" + key + "?]";
            }
            log.warn("ERROR! Resource string not found: [" + resKey + "]", (Throwable)mre);
            resString = defaultValue;
        }
        return resString;
    }

    public static String getParsedLabel(String key) {
        String value = JMeterUtils.getResString(key);
        return value.replaceFirst("(?m)\\s*?:\\s*$", "");
    }

    public static String getLocaleString(String locale) {
        String resKey = locale.toLowerCase(Locale.ENGLISH);
        try {
            return resources.getString(resKey);
        }
        catch (MissingResourceException missingResourceException) {
            return locale;
        }
    }

    public static Properties getJMeterProperties() {
        return appProperties;
    }

    public static ImageIcon getImage(String name) {
        try {
            return new ImageIcon(JMeterUtils.class.getClassLoader().getResource("org/apache/jmeter/images/" + name.trim()));
        }
        catch (NullPointerException e) {
            log.warn("no icon for " + name);
            return null;
        }
        catch (NoClassDefFoundError e) {
            log.info("no icon for " + name + " " + e.getMessage());
            return null;
        }
        catch (InternalError e) {
            log.info("no icon for " + name + " " + e.getMessage());
            return null;
        }
    }

    public static ImageIcon getImage(String name, String description) {
        ImageIcon icon = JMeterUtils.getImage(name);
        if (icon != null) {
            icon.setDescription(description);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getResourceFileAsText(String name) {
        BufferedReader fileReader = null;
        try {
            String lineEnd = System.getProperty("line.separator");
            fileReader = new BufferedReader(new InputStreamReader(JMeterUtils.class.getClassLoader().getResourceAsStream(name)));
            StringBuilder text = new StringBuilder();
            String line = "NOTNULL";
            while (line != null) {
                line = fileReader.readLine();
                if (line == null) continue;
                text.append(line);
                text.append(lineEnd);
            }
            String string = text.toString();
            IOUtils.closeQuietly((Reader)fileReader);
            return string;
        }
        catch (NullPointerException e) {
            String string = "";
            return string;
        }
        catch (IOException e2) {
            String string = "";
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(fileReader);
        }
    }

    public static Vector<Object> getTimers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "timer."), "org.apache.jmeter.timers.Timer");
    }

    public static Vector<Object> getVisualizers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "visualizer."), "org.apache.jmeter.visualizers.Visualizer");
    }

    public static Vector<Object> getControllers(Properties properties) {
        String name = "controller.";
        Vector<Object> v = new Vector<Object>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            Object o = JMeterUtils.instantiate(properties.getProperty(prop), "org.apache.jmeter.control.SamplerController");
            v.addElement(o);
        }
        return v;
    }

    public static String[] getTestSamples(Properties properties, String name) {
        Vector<String> vector = JMeterUtils.getVector(properties, name + ".testsample");
        return vector.toArray(new String[vector.size()]);
    }

    public static XMLReader getXMLParser() {
        XMLReader reader = null;
        String parserName = JMeterUtils.getPropDefault("xml.parser", "org.apache.xerces.parsers.SAXParser");
        try {
            reader = (XMLReader)JMeterUtils.instantiate(parserName, "org.xml.sax.XMLReader");
        }
        catch (Exception e) {
            reader = (XMLReader)JMeterUtils.instantiate(parserName, "org.xml.sax.XMLReader");
        }
        return reader;
    }

    public static Hashtable<String, String> getAlias(Properties properties) {
        return JMeterUtils.getHashtable(properties, "alias.");
    }

    public static Vector<String> getVector(Properties properties, String name) {
        Vector<String> v = new Vector<String>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            v.addElement(properties.getProperty(prop));
        }
        return v;
    }

    public static Hashtable<String, String> getHashtable(Properties properties, String prefix) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        Enumeration<Object> names = properties.keys();
        int length = prefix.length();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(prefix)) continue;
            t.put(prop.substring(length), properties.getProperty(prop));
        }
        return t;
    }

    public static int getPropDefault(String propName, int defaultVal) {
        int ans;
        try {
            ans = Integer.valueOf(appProperties.getProperty(propName, Integer.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static boolean getPropDefault(String propName, boolean defaultVal) {
        boolean ans;
        try {
            String strVal = appProperties.getProperty(propName, Boolean.toString(defaultVal)).trim();
            ans = strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("t") ? true : (strVal.equalsIgnoreCase("false") || strVal.equalsIgnoreCase("f") ? false : Integer.valueOf(strVal) == 1);
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static long getPropDefault(String propName, long defaultVal) {
        long ans;
        try {
            ans = Long.valueOf(appProperties.getProperty(propName, Long.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static String getPropDefault(String propName, String defaultVal) {
        String ans = defaultVal;
        try {
            String value = appProperties.getProperty(propName, defaultVal);
            if (value != null) {
                ans = value.trim();
            }
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static String getProperty(String propName) {
        String ans = null;
        try {
            ans = appProperties.getProperty(propName);
        }
        catch (Exception e) {
            ans = null;
        }
        return ans;
    }

    public static Object setProperty(String propName, String propValue) {
        return appProperties.setProperty(propName, propValue);
    }

    public static void selJComboBoxItem(Properties properties, JComboBox combo, Vector<?> namVec, String name) {
        int idx = namVec.indexOf(name);
        combo.setSelectedIndex(idx);
        combo.updateUI();
    }

    public static Object instantiate(String className, String impls) {
        if (className != null) {
            className = className.trim();
        }
        if (impls != null) {
            impls = impls.trim();
        }
        try {
            Class<?> c = Class.forName(impls);
            try {
                Class<?> o = Class.forName(className);
                Object res = o.newInstance();
                if (c.isInstance(res)) {
                    return res;
                }
                throw new IllegalArgumentException(className + " is not an instance of " + impls);
            }
            catch (ClassNotFoundException e) {
                log.error("Error loading class " + className + ": class is not found");
            }
            catch (IllegalAccessException e) {
                log.error("Error loading class " + className + ": does not have access");
            }
            catch (InstantiationException e) {
                log.error("Error loading class " + className + ": could not instantiate");
            }
            catch (NoClassDefFoundError e) {
                log.error("Error loading class " + className + ": couldn't find class " + e.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading class " + impls + ": was not found.");
        }
        return null;
    }

    public static Vector<Object> instantiate(Vector<String> v, String className) {
        Vector<Object> i = new Vector<Object>();
        try {
            Class<?> c = Class.forName(className);
            Enumeration<String> elements = v.elements();
            while (elements.hasMoreElements()) {
                String name = elements.nextElement();
                try {
                    Object o = Class.forName(name).newInstance();
                    if (!c.isInstance(o)) continue;
                    i.addElement(o);
                }
                catch (ClassNotFoundException e) {
                    log.error("Error loading class " + name + ": class is not found");
                }
                catch (IllegalAccessException e) {
                    log.error("Error loading class " + name + ": does not have access");
                }
                catch (InstantiationException e) {
                    log.error("Error loading class " + name + ": could not instantiate");
                }
                catch (NoClassDefFoundError e) {
                    log.error("Error loading class " + name + ": couldn't find class " + e.getMessage());
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading class " + className + ": class is not found");
        }
        return i;
    }

    public static JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(JMeterUtils.getImage(name + ".on.gif"));
        button.setDisabledIcon(JMeterUtils.getImage(name + ".off.gif"));
        button.setRolloverIcon(JMeterUtils.getImage(name + ".over.gif"));
        button.setPressedIcon(JMeterUtils.getImage(name + ".down.gif"));
        button.setActionCommand(name);
        button.addActionListener(listener);
        button.setRolloverEnabled(true);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setPreferredSize(new Dimension(24, 24));
        return button;
    }

    public static JButton createSimpleButton(String name, ActionListener listener) {
        JButton button = new JButton(JMeterUtils.getImage(name + ".gif"));
        button.setActionCommand(name);
        button.addActionListener(listener);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setPreferredSize(new Dimension(25, 25));
        return button;
    }

    public static void reportErrorToUser(String errorMsg) {
        JMeterUtils.reportErrorToUser(errorMsg, JMeterUtils.getResString("error_title"));
    }

    public static void reportErrorToUser(String errorMsg, String titleMsg) {
        GuiPackage instance;
        if (errorMsg == null) {
            errorMsg = "Unknown error - see log file";
            log.warn("Unknown error", new Throwable("errorMsg == null"));
        }
        if ((instance = GuiPackage.getInstance()) == null) {
            System.out.println(errorMsg);
            return;
        }
        try {
            JOptionPane.showMessageDialog(instance.getMainFrame(), errorMsg, titleMsg, 0);
        }
        catch (HeadlessException e) {
            log.warn("reportErrorToUser(\"" + errorMsg + "\") caused", (Throwable)e);
        }
    }

    public static int findInArray(String[] array, String value) {
        int count = -1;
        int index = -1;
        if (array != null && value != null) {
            while (++count < array.length) {
                if (array[count] == null || !array[count].equals(value)) continue;
                index = count;
                break;
            }
        }
        return index;
    }

    public static String unsplit(Object[] splittee, Object splitChar) {
        StringBuilder retVal = new StringBuilder();
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            }
            if (count + 1 >= splittee.length || splittee[count + 1] == null) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String unsplit(Object[] splittee, Object splitChar, String def) {
        StringBuilder retVal = new StringBuilder();
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            } else {
                retVal.append(def);
            }
            if (count + 1 >= splittee.length) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String getJMeterHome() {
        return jmDir;
    }

    public static String getJMeterBinDir() {
        return jmBin;
    }

    public static void setJMeterHome(String home) {
        jmDir = home;
        jmBin = jmDir + File.separator + "bin";
    }

    public static String getJMeterVersion() {
        return JMeterVersion.getVERSION();
    }

    public static String getJMeterCopyright() {
        return JMeterVersion.getCopyRight();
    }

    public static boolean isExpertMode() {
        return JMeterUtils.getPropDefault(EXPERT_MODE_PROPERTY, false);
    }

    public static File findFile(String fileName) {
        File f = new File(fileName);
        if (!f.exists()) {
            f = new File(JMeterUtils.getJMeterBinDir(), fileName);
        }
        return f;
    }

    public static synchronized String getLocalHostIP() {
        if (localHostIP == null) {
            JMeterUtils.getLocalHostDetails();
        }
        return localHostIP;
    }

    public static synchronized String getLocalHostName() {
        if (localHostName == null) {
            JMeterUtils.getLocalHostDetails();
        }
        return localHostName;
    }

    public static synchronized String getLocalHostFullName() {
        if (localHostFullName == null) {
            JMeterUtils.getLocalHostDetails();
        }
        return localHostFullName;
    }

    private static void getLocalHostDetails() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e1) {
            log.error("Unable to get local host IP address.");
            return;
        }
        localHostIP = localHost.getHostAddress();
        localHostName = localHost.getHostName();
        localHostFullName = localHost.getCanonicalHostName();
    }

    public static LinkedHashMap<String, String> parseHeaders(String headers) {
        String[] list;
        LinkedHashMap<String, String> linkedHeaders = new LinkedHashMap<String, String>();
        for (String header : list = headers.split("\n")) {
            int colon = header.indexOf(58);
            if (colon <= 0) {
                linkedHeaders.put(header, "");
                continue;
            }
            linkedHeaders.put(header.substring(0, colon).trim(), header.substring(colon + 1).trim());
        }
        return linkedHeaders;
    }

    public static final void runSafe(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                throw new Error(e);
            }
        }
    }

    static {
        localeChangeListeners = new Vector();
        localHostIP = null;
        localHostName = null;
        localHostFullName = null;
        ignoreResorces = false;
        localMatcher = new ThreadLocal<Perl5Matcher>(){

            @Override
            protected Perl5Matcher initialValue() {
                return new Perl5Matcher();
            }
        };
        rand = new Random();
    }

    private static class LazyPatternCacheHolder {
        public static final PatternCacheLRU INSTANCE = new PatternCacheLRU(JMeterUtils.getPropDefault("oro.patterncache.size", 1000), (PatternCompiler)new Perl5Compiler());

        private LazyPatternCacheHolder() {
        }
    }
}

