/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public abstract class JSR223TestElement
extends AbstractTestElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 233L;
    private String parameters;
    private String filename;
    private String script;
    private String scriptLanguage;

    public JSR223TestElement() {
        this.init();
    }

    private void init() {
        this.parameters = "";
        this.filename = "";
        this.script = "";
        this.scriptLanguage = "";
    }

    protected Object readResolve() {
        this.init();
        return this;
    }

    public Object clone() {
        JSR223TestElement o = (JSR223TestElement)super.clone();
        o.init();
        return o;
    }

    protected ScriptEngineManager getManager() {
        ScriptEngineManager sem = new ScriptEngineManager();
        this.initManager(sem);
        return sem;
    }

    protected void initManager(ScriptEngineManager sem) {
        String label = this.getName();
        String fileName = this.getFilename();
        String scriptParameters = this.getParameters();
        Logger logger = LoggingManager.getLoggerForShortName((String)this.getClass().getName());
        sem.put("log", logger);
        sem.put("Label", label);
        sem.put("FileName", fileName);
        sem.put("Parameters", scriptParameters);
        String[] args = JOrphanUtils.split((String)scriptParameters, (String)" ");
        sem.put("args", args);
        JMeterContext jmctx = JMeterContextService.getContext();
        sem.put("ctx", jmctx);
        JMeterVariables vars = jmctx.getVariables();
        sem.put("vars", vars);
        Properties props = JMeterUtils.getJMeterProperties();
        sem.put("props", props);
        sem.put("OUT", System.out);
        Sampler sampler = jmctx.getCurrentSampler();
        sem.put("sampler", sampler);
        SampleResult prev = jmctx.getPreviousResult();
        sem.put("prev", prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processFileOrScript(ScriptEngineManager sem) throws IOException, ScriptException {
        String lang = this.getScriptLanguage();
        ScriptEngine scriptEngine = sem.getEngineByName(lang);
        if (scriptEngine == null) {
            throw new ScriptException("Cannot find engine named: " + lang);
        }
        File scriptFile = new File(this.getFilename());
        if (scriptFile.exists()) {
            Object object;
            BufferedReader fileReader = null;
            try {
                fileReader = new BufferedReader(new FileReader(scriptFile));
                object = scriptEngine.eval(fileReader);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)fileReader);
            return object;
        }
        return scriptEngine.eval(this.getScript());
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String s) {
        this.script = s;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String s) {
        this.parameters = s;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String s) {
        this.filename = s;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String s) {
        this.scriptLanguage = s;
    }
}

