/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.apache.xml.utils.PrefixResolverDefault;
import org.w3c.dom.Node;

public class PropertiesBasedPrefixResolver
extends PrefixResolverDefault {
    private static final Logger logger = LoggingManager.getLoggerForClass();
    private static final String XPATH_NAMESPACE_CONFIG = "xpath.namespace.config";
    private static final Map<String, String> NAMESPACE_MAP = new HashMap<String, String>();

    public PropertiesBasedPrefixResolver(Node xpathExpressionContext) {
        super(xpathExpressionContext);
    }

    public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
        String namespace = NAMESPACE_MAP.get(prefix);
        if (namespace == null) {
            return super.getNamespaceForPrefix(prefix, namespaceContext);
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String pathToNamespaceConfig = JMeterUtils.getPropDefault(XPATH_NAMESPACE_CONFIG, "");
        if (!StringUtils.isEmpty((String)pathToNamespaceConfig)) {
            BufferedInputStream inputStream;
            block8: {
                Properties properties = new Properties();
                inputStream = null;
                try {
                    File pathToNamespaceConfigFile = JMeterUtils.findFile(pathToNamespaceConfig);
                    if (!pathToNamespaceConfigFile.exists()) {
                        logger.error("Cannot find configured file:'" + pathToNamespaceConfig + "' in property:'" + XPATH_NAMESPACE_CONFIG + "', file does not exist");
                        break block8;
                    }
                    if (!pathToNamespaceConfigFile.canRead()) {
                        logger.error("Cannot read configured file:'" + pathToNamespaceConfig + "' in property:'" + XPATH_NAMESPACE_CONFIG + "'");
                        break block8;
                    }
                    inputStream = new BufferedInputStream(new FileInputStream(pathToNamespaceConfigFile));
                    properties.load(inputStream);
                    properties.entrySet();
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        NAMESPACE_MAP.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    logger.info("Read following XPath namespace configuration " + NAMESPACE_MAP);
                }
                catch (IOException e) {
                    try {
                        logger.error("Error loading namespaces from file:'" + pathToNamespaceConfig + "', message:" + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JOrphanUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    JOrphanUtils.closeQuietly((Closeable)inputStream);
                }
            }
            JOrphanUtils.closeQuietly((Closeable)inputStream);
        }
    }
}

