/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;

public class HttpDefaultsGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox imageParser;
    private JCheckBox concurrentDwn;
    private JTextField concurrentPool;
    private UrlConfigGui urlConfig;

    public HttpDefaultsGui() {
        this.init();
    }

    public String getLabelResource() {
        return "url_config_title";
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        ConfigTestElement cfg = (ConfigTestElement)config;
        ConfigTestElement el = (ConfigTestElement)this.urlConfig.createTestElement();
        cfg.clear();
        cfg.addConfigElement((ConfigElement)el);
        super.configureTestElement(config);
        if (this.imageParser.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.image_parser", true));
            this.enableConcurrentDwn(true);
        } else {
            config.removeProperty("HTTPSampler.image_parser");
            this.enableConcurrentDwn(false);
        }
        if (this.concurrentDwn.isSelected()) {
            config.setProperty((JMeterProperty)new BooleanProperty("HTTPSampler.concurrentDwn", true));
        } else {
            config.removeProperty("HTTPSampler.concurrentDwn");
        }
        if (!StringUtils.isEmpty((String)this.concurrentPool.getText())) {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.concurrentPool", this.concurrentPool.getText()));
        } else {
            config.setProperty((JMeterProperty)new StringProperty("HTTPSampler.concurrentPool", String.valueOf(4)));
        }
    }

    public void clearGui() {
        super.clearGui();
        this.urlConfig.clear();
        this.imageParser.setSelected(false);
        this.concurrentDwn.setSelected(false);
        this.concurrentPool.setText(String.valueOf(4));
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.urlConfig.configure(el);
        this.imageParser.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("HTTPSampler.image_parser"));
        this.concurrentDwn.setSelected(((AbstractTestElement)el).getPropertyAsBoolean("HTTPSampler.concurrentDwn"));
        this.concurrentPool.setText(((AbstractTestElement)el).getPropertyAsString("HTTPSampler.concurrentPool"));
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.urlConfig = new UrlConfigGui(false, true, false);
        this.add(this.urlConfig, "Center");
        HorizontalPanel optionalTasksPanel = new HorizontalPanel();
        optionalTasksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"optional_tasks")));
        HorizontalPanel checkBoxPanel = new HorizontalPanel();
        this.imageParser = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        checkBoxPanel.add(this.imageParser);
        this.imageParser.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    HttpDefaultsGui.this.enableConcurrentDwn(true);
                } else {
                    HttpDefaultsGui.this.enableConcurrentDwn(false);
                }
            }
        });
        this.concurrentDwn = new JCheckBox(JMeterUtils.getResString((String)"web_testing_concurrent_download"));
        this.concurrentDwn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (HttpDefaultsGui.this.imageParser.isSelected() && e.getStateChange() == 1) {
                    HttpDefaultsGui.this.concurrentPool.setEnabled(true);
                } else {
                    HttpDefaultsGui.this.concurrentPool.setEnabled(false);
                }
            }
        });
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMaximumSize(new Dimension(30, 20));
        checkBoxPanel.add(this.concurrentDwn);
        checkBoxPanel.add(this.concurrentPool);
        optionalTasksPanel.add((Component)checkBoxPanel);
        this.add((Component)optionalTasksPanel, "South");
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void enableConcurrentDwn(boolean enable) {
        if (enable) {
            this.concurrentDwn.setEnabled(true);
            if (this.concurrentDwn.isSelected()) {
                this.concurrentPool.setEnabled(true);
            }
        } else {
            this.concurrentDwn.setEnabled(false);
            this.concurrentPool.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.enableConcurrentDwn(true);
        } else {
            this.enableConcurrentDwn(false);
        }
    }
}

