/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;

public class HTTPFileImpl
extends HTTPAbstractImpl {
    protected HTTPFileImpl(HTTPSamplerBase base) {
        super(base);
    }

    public boolean interrupt() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        HTTPSampleResult hTTPSampleResult;
        HTTPSampleResult res = new HTTPSampleResult();
        res.setHTTPMethod("GET");
        res.setURL(url);
        res.setSampleLabel(url.toString());
        InputStream is = null;
        res.sampleStart();
        try {
            try {
                URLConnection conn = url.openConnection();
                is = conn.getInputStream();
                byte[] responseData = IOUtils.toByteArray((InputStream)is);
                res.sampleEnd();
                res.setResponseData(responseData);
                res.setResponseCodeOK();
                res.setResponseMessageOK();
                res.setSuccessful(true);
                StringBuilder ctb = new StringBuilder("text/html");
                String contentEncoding = this.getContentEncoding();
                if (contentEncoding.length() > 0) {
                    ctb.append("; charset=");
                    ctb.append(contentEncoding);
                }
                String ct = ctb.toString();
                res.setContentType(ct);
                res.setEncodingAndType(ct);
                hTTPSampleResult = res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
                Object var14_17 = null;
            }
            catch (FileNotFoundException e) {
                HTTPSampleResult hTTPSampleResult2 = this.errorResult(e, res);
                Object var14_18 = null;
                IOUtils.closeQuietly((InputStream)is);
                return hTTPSampleResult2;
            }
            catch (IOException e) {
                HTTPSampleResult hTTPSampleResult3 = this.errorResult(e, res);
                Object var14_19 = null;
                IOUtils.closeQuietly((InputStream)is);
                return hTTPSampleResult3;
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            IOUtils.closeQuietly((InputStream)is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return hTTPSampleResult;
    }
}

