/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.util.WSDLException;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLHelper {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static int GET_WDSL_TIMEOUT = 5000;
    private URL WSDLURL = null;
    private URLConnection CONN = null;
    private Document WSDLDOC = null;
    private String SOAPBINDING = null;
    private URL bindingURL = null;
    private Object[] SOAPOPS = null;
    private final Map<String, String> ACTIONS = new HashMap<String, String>();
    private final AuthManager AUTH;

    public WSDLHelper(String url) throws MalformedURLException {
        this(url, null);
    }

    public WSDLHelper(String url, AuthManager auth) throws MalformedURLException {
        this.WSDLURL = new URL(url);
        this.AUTH = auth;
    }

    public URL getURL() {
        return this.WSDLURL;
    }

    public String getProtocol() {
        return this.bindingURL.getProtocol();
    }

    public String getBindingHost() {
        return this.bindingURL.getHost();
    }

    public String getBindingPath() {
        return this.bindingURL.getPath();
    }

    public int getBindingPort() {
        return this.bindingURL.getPort();
    }

    public String getBinding() {
        try {
            Element node;
            NodeList ports;
            NodeList services = this.WSDLDOC.getElementsByTagName("service");
            if (services.getLength() == 0) {
                services = this.WSDLDOC.getElementsByTagName("wsdl:service");
            }
            if ((ports = (node = (Element)services.item(0)).getElementsByTagName("port")).getLength() == 0) {
                ports = node.getElementsByTagName("wsdl:port");
            }
            if (ports.getLength() > 0) {
                Element pnode = (Element)ports.item(0);
                NodeList servlist = pnode.getElementsByTagName("soap:address");
                if (servlist.getLength() == 0) {
                    servlist = pnode.getElementsByTagName("wsdlsoap:address");
                }
                if (servlist.getLength() == 0) {
                    servlist = pnode.getElementsByTagName("SOAP:address");
                }
                Element addr = (Element)servlist.item(0);
                this.SOAPBINDING = addr.getAttribute("location");
                this.bindingURL = new URL(this.SOAPBINDING);
                return this.SOAPBINDING;
            }
            return null;
        }
        catch (Exception exception) {
            log.warn("Exception calling getBinding:" + exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    protected void connect() throws IOException {
        this.CONN = this.WSDLURL.openConnection();
        this.CONN.setConnectTimeout(GET_WDSL_TIMEOUT);
        this.CONN.setReadTimeout(GET_WDSL_TIMEOUT);
        if (this.CONN instanceof HttpURLConnection && this.AUTH != null && this.AUTH.getAuthHeaderForURL(this.WSDLURL) != null) {
            this.CONN.setRequestProperty("Authorization", this.AUTH.getAuthHeaderForURL(this.WSDLURL));
        }
    }

    protected void close() {
        try {
            if (this.CONN != null) {
                this.CONN.getInputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void buildDocument() throws ParserConfigurationException, IOException, SAXException {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuild = dbfactory.newDocumentBuilder();
            this.WSDLDOC = docbuild.parse(this.CONN.getInputStream());
        }
        catch (ParserConfigurationException exception) {
            throw exception;
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (SAXException exception) {
            throw exception;
        }
    }

    public void parse() throws WSDLException {
        try {
            this.connect();
            this.buildDocument();
            this.SOAPOPS = this.getOperations();
        }
        catch (IOException exception) {
            throw new WSDLException(exception);
        }
        catch (SAXException exception) {
            throw new WSDLException(exception);
        }
        catch (ParserConfigurationException exception) {
            throw new WSDLException(exception);
        }
        finally {
            this.close();
        }
    }

    public String[] getWebMethods() {
        for (int idx = 0; idx < this.SOAPOPS.length; ++idx) {
            Element op;
            Node act = (Node)this.SOAPOPS[idx];
            NodeList opers = ((Element)act).getElementsByTagName("soap:operation");
            if (opers.getLength() == 0) {
                opers = ((Element)act).getElementsByTagName("wsdlsoap:operation");
            }
            if (opers.getLength() == 0) {
                opers = ((Element)act).getElementsByTagName("wsdl:operation");
            }
            if (opers.getLength() == 0) {
                opers = ((Element)act).getElementsByTagName("operation");
            }
            String value = (op = (Element)opers.item(0)) != null ? op.getAttribute("soapAction") : "";
            String key = ((Element)act).getAttribute("name");
            this.ACTIONS.put(key, value);
        }
        Set<String> keys = this.ACTIONS.keySet();
        String[] stringmeth = new String[keys.size()];
        Object[] stringKeys = keys.toArray();
        System.arraycopy(stringKeys, 0, stringmeth, 0, keys.size());
        return stringmeth;
    }

    public String getSoapAction(String key) {
        return this.ACTIONS.get(key);
    }

    public Document getWSDLDocument() {
        return this.WSDLDOC;
    }

    public Object[] getSOAPBindings() {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList bindings = this.WSDLDOC.getElementsByTagName("binding");
        String soapBind = "soap:binding";
        if (bindings.getLength() == 0) {
            bindings = this.WSDLDOC.getElementsByTagName("wsdl:binding");
        }
        if (this.WSDLDOC.getElementsByTagName(soapBind).getLength() == 0) {
            soapBind = "wsdlsoap:binding";
        }
        if (this.WSDLDOC.getElementsByTagName(soapBind).getLength() == 0) {
            soapBind = "SOAP:binding";
        }
        for (int idx = 0; idx < bindings.getLength(); ++idx) {
            Element nd = (Element)bindings.item(idx);
            NodeList slist = nd.getElementsByTagName(soapBind);
            if (slist.getLength() <= 0) continue;
            nd.getAttribute("name");
            list.add(nd);
        }
        if (list.size() > 0) {
            return list.toArray();
        }
        return new Object[0];
    }

    public Object[] getOperations() {
        Object[] res = this.getSOAPBindings();
        ArrayList<Element> ops = new ArrayList<Element>();
        for (int idx = 0; idx < res.length; ++idx) {
            Element one = (Element)res[idx];
            NodeList opnodes = one.getElementsByTagName("operation");
            String soapOp = "soap:operation";
            if (opnodes.getLength() == 0) {
                opnodes = one.getElementsByTagName("wsdl:operation");
            }
            if (one.getElementsByTagName(soapOp).getLength() == 0) {
                soapOp = "wsdlsoap:operation";
            }
            for (int idz = 0; idz < opnodes.getLength(); ++idz) {
                Element child = (Element)opnodes.item(idz);
                NodeList soapnode = child.getElementsByTagName(soapOp);
                if (soapnode.getLength() > 0) {
                    ops.add(child);
                    continue;
                }
                ops.add(child);
            }
        }
        return ops.toArray();
    }

    public String getSoapActionName(String soapAction) {
        for (Map.Entry<String, String> entry : this.ACTIONS.entrySet()) {
            if (!entry.getValue().equals(soapAction)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            WSDLHelper help = new WSDLHelper("http://localhost:8080/ServiceGateway.wsdl");
            long start = System.currentTimeMillis();
            help.parse();
            String[] methods = help.getWebMethods();
            System.out.println("el: " + (System.currentTimeMillis() - start));
            for (int idx = 0; idx < methods.length; ++idx) {
                System.out.println("method name: " + methods[idx]);
            }
            System.out.println("service url: " + help.getBinding());
            System.out.println("protocol: " + help.getProtocol());
            System.out.println("port=" + help.getURL().getPort());
        }
        catch (Exception exception) {
            System.out.println("main method catch:");
            exception.printStackTrace();
        }
    }
}

