/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.SaveGraphics;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RespTimeGraphChart;
import org.apache.jmeter.visualizers.RespTimeGraphDataBean;
import org.apache.jmeter.visualizers.RespTimeGraphLineBean;
import org.apache.jmeter.visualizers.StatGraphProperties;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jmeter.visualizers.utils.Colors;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RespTimeGraphVisualizer
extends AbstractVisualizer
implements ActionListener,
Clearable {
    private static final long serialVersionUID = 280L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Font FONT_SMALL = new Font("SansSerif", 0, 10);
    private final transient Object lock = new Object();
    private final transient Object lockInterval = new Object();
    private static final String Y_AXIS_LABEL = JMeterUtils.getResString((String)"aggregate_graph_response_time");
    private static final String Y_AXIS_TITLE = JMeterUtils.getResString((String)"aggregate_graph_ms");
    private RespTimeGraphChart graphPanel = null;
    private final JTabbedPane tabbedGraph = new JTabbedPane(1);
    private boolean saveGraphToFile = false;
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGTH = 300;
    private static final int INTERVAL_DEFAULT = 10000;
    private int intervalValue = 10000;
    private final JLabeledTextField intervalField = new JLabeledTextField(JMeterUtils.getResString((String)"graph_resp_time_interval_label"), 7);
    private final JButton intervalButton = new JButton(JMeterUtils.getResString((String)"graph_resp_time_interval_reload"));
    private final JButton displayButton = new JButton(JMeterUtils.getResString((String)"aggregate_graph_display"));
    private final JButton saveGraph = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save"));
    private final JCheckBox samplerSelection = new JCheckBox(JMeterUtils.getResString((String)"graph_resp_time_series_selection"), false);
    private final JTextField samplerMatchLabel = new JTextField();
    private final JButton applyFilterBtn = new JButton(JMeterUtils.getResString((String)"graph_apply_filter"));
    private final JCheckBox caseChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_case"), false);
    private final JCheckBox regexpChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_regexp"), true);
    private final JComboBox titleFontNameList = new JComboBox<Object>(StatGraphProperties.getFontNameMap().keySet().toArray());
    private final JComboBox titleFontSizeList = new JComboBox<String>(StatGraphProperties.fontSize);
    private final JComboBox titleFontStyleList = new JComboBox<Object>(StatGraphProperties.getFontStyleMap().keySet().toArray());
    private final JComboBox fontNameList = new JComboBox<Object>(StatGraphProperties.getFontNameMap().keySet().toArray());
    private final JComboBox fontSizeList = new JComboBox<String>(StatGraphProperties.fontSize);
    private final JComboBox fontStyleList = new JComboBox<Object>(StatGraphProperties.getFontStyleMap().keySet().toArray());
    private final JComboBox legendPlacementList = new JComboBox<Object>(StatGraphProperties.getPlacementNameMap().keySet().toArray());
    private final JComboBox pointShapeLine = new JComboBox<Object>(StatGraphProperties.getPointShapeMap().keySet().toArray());
    private final JComboBox strokeWidthList = new JComboBox<String>(StatGraphProperties.strokeWidth);
    private final JCheckBox numberShowGrouping = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_number_grouping"), true);
    private final JButton syncWithName = new JButton(JMeterUtils.getResString((String)"aggregate_graph_sync_with_name"));
    private final JLabeledTextField graphTitle = new JLabeledTextField(JMeterUtils.getResString((String)"graph_resp_time_title_label"));
    private final JLabeledTextField xAxisTimeFormat = new JLabeledTextField(JMeterUtils.getResString((String)"graph_resp_time_xaxis_time_format"), 10);
    private final JLabeledTextField maxValueYAxisLabel = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_yaxis_max_value"), 8);
    private final JCheckBox dynamicGraphSize = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_dynamic_size"));
    private final JLabeledTextField graphWidth = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_width"), 6);
    private final JLabeledTextField graphHeight = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_height"), 6);
    private int minStartTime = Integer.MAX_VALUE;
    private int maxStartTime = Integer.MIN_VALUE;
    private final Map<String, RespTimeGraphLineBean> seriesNames = new LinkedHashMap<String, RespTimeGraphLineBean>();
    private final Map<String, Map<Integer, Long>> pList = new LinkedHashMap<String, Map<Integer, Long>>();
    private int durationTest = 0;
    private int colorIdx = 0;
    private Pattern pattern = null;
    private transient Matcher matcher = null;
    private final List<Color> listColors = Colors.getColors();
    private final List<RespTimeGraphDataBean> internalList = new ArrayList<RespTimeGraphDataBean>();

    public RespTimeGraphVisualizer() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final SampleResult sampleResult) {
        final String sampleLabel = sampleResult.getSampleLabel();
        Object object = this.lockInterval;
        synchronized (object) {
            this.internalList.add(new RespTimeGraphDataBean(sampleResult.getStartTime(), sampleResult.getTime(), sampleLabel));
        }
        if (this.samplerSelection.isSelected() && this.pattern != null) {
            this.matcher = this.pattern.matcher(sampleLabel);
        }
        if (this.matcher == null || this.matcher.find()) {
            long startTimeMS = sampleResult.getStartTime();
            final int startTimeInterval = (int)startTimeMS / this.intervalValue;
            JMeterUtils.runSafe((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = RespTimeGraphVisualizer.this.lock;
                    synchronized (object) {
                        Map subList;
                        if (startTimeInterval < RespTimeGraphVisualizer.this.minStartTime) {
                            RespTimeGraphVisualizer.this.minStartTime = startTimeInterval;
                        } else if (startTimeInterval > RespTimeGraphVisualizer.this.maxStartTime) {
                            RespTimeGraphVisualizer.this.maxStartTime = startTimeInterval;
                        }
                        if (!RespTimeGraphVisualizer.this.seriesNames.containsKey(sampleLabel)) {
                            RespTimeGraphVisualizer.this.seriesNames.put(sampleLabel, new RespTimeGraphLineBean(sampleLabel, (Color)RespTimeGraphVisualizer.this.listColors.get(RespTimeGraphVisualizer.this.colorIdx++)));
                            if (RespTimeGraphVisualizer.this.colorIdx >= RespTimeGraphVisualizer.this.listColors.size()) {
                                RespTimeGraphVisualizer.this.colorIdx = 0;
                            }
                        }
                        if ((subList = (Map)RespTimeGraphVisualizer.this.pList.get(sampleLabel)) != null) {
                            long respTime = sampleResult.getTime();
                            Long value = (Long)subList.get(startTimeInterval);
                            if (value != null) {
                                respTime = (value + respTime) / 2L;
                            }
                            subList.put(startTimeInterval, respTime);
                        } else {
                            LinkedHashMap<Integer, Long> newSubList = new LinkedHashMap<Integer, Long>();
                            newSubList.put(startTimeInterval, sampleResult.getTime());
                            RespTimeGraphVisualizer.this.pList.put(sampleLabel, newSubList);
                        }
                    }
                }
            });
        }
    }

    public void makeGraph() {
        String yAxisStr;
        Dimension size = this.graphPanel.getSize();
        int width = (int)size.getWidth();
        int height = (int)size.getHeight();
        if (!this.dynamicGraphSize.isSelected()) {
            String wstr = this.graphWidth.getText();
            String hstr = this.graphHeight.getText();
            if (wstr.length() != 0) {
                width = Integer.parseInt(wstr);
            }
            if (hstr.length() != 0) {
                height = Integer.parseInt(hstr);
            }
        }
        int maxYAxisScale = (yAxisStr = this.maxValueYAxisLabel.getText()).length() == 0 ? 0 : Integer.parseInt(yAxisStr);
        this.graphPanel.setData(this.getData());
        this.graphPanel.setTitle(this.graphTitle.getText());
        this.graphPanel.setMaxYAxisScale(maxYAxisScale);
        this.graphPanel.setYAxisLabels(Y_AXIS_LABEL);
        this.graphPanel.setYAxisTitle(Y_AXIS_TITLE);
        this.graphPanel.setXAxisLabels(this.getXAxisLabels());
        this.graphPanel.setLegendLabels(this.getLegendLabels());
        this.graphPanel.setColor(this.getLinesColors());
        this.graphPanel.setShowGrouping(this.numberShowGrouping.isSelected());
        this.graphPanel.setLegendPlacement(StatGraphProperties.getPlacementNameMap().get(this.legendPlacementList.getSelectedItem()));
        this.graphPanel.setPointShape(StatGraphProperties.getPointShapeMap().get(this.pointShapeLine.getSelectedItem()));
        this.graphPanel.setStrokeWidth(Float.parseFloat((String)this.strokeWidthList.getSelectedItem()));
        this.graphPanel.setTitleFont(new Font(StatGraphProperties.getFontNameMap().get(this.titleFontNameList.getSelectedItem()), (int)StatGraphProperties.getFontStyleMap().get(this.titleFontStyleList.getSelectedItem()), Integer.parseInt((String)this.titleFontSizeList.getSelectedItem())));
        this.graphPanel.setLegendFont(new Font(StatGraphProperties.getFontNameMap().get(this.fontNameList.getSelectedItem()), (int)StatGraphProperties.getFontStyleMap().get(this.fontStyleList.getSelectedItem()), Integer.parseInt((String)this.fontSizeList.getSelectedItem())));
        this.graphPanel.setHeight(height);
        this.graphPanel.setWidth(width);
        this.graphPanel.repaint();
    }

    public double[][] getData() {
        int size = this.pList.size();
        int max = this.durationTest;
        double[][] data = new double[size][max];
        double nanLast = 0.0;
        double nanBegin = 0.0;
        ArrayList<Double> nanList = new ArrayList<Double>();
        int s = 0;
        for (Map<Integer, Long> subList : this.pList.values()) {
            for (int idx = 0; idx < this.durationTest; ++idx) {
                int keyShift = this.minStartTime + idx;
                Long value = subList.get(keyShift);
                if (value != null) {
                    data[s][idx] = nanLast = value.doubleValue();
                    int nlsize = nanList.size();
                    if (nlsize <= 0) continue;
                    double valPrev = nanBegin;
                    for (int cnt = 0; cnt < nlsize; ++cnt) {
                        int pos = idx - (nlsize - cnt);
                        if (pos < 0) {
                            pos = 0;
                        }
                        data[s][pos] = valPrev += (nanLast - nanBegin) / (double)(nlsize + 2);
                    }
                    nanList.clear();
                    continue;
                }
                nanList.add(Double.NaN);
                nanBegin = nanLast;
                data[s][idx] = Double.NaN;
            }
            ++s;
        }
        return data;
    }

    public String getLabelResource() {
        return "graph_resp_time_title";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.lock;
        synchronized (object) {
            this.internalList.clear();
            this.seriesNames.clear();
            this.pList.clear();
            this.minStartTime = Integer.MAX_VALUE;
            this.maxStartTime = Integer.MIN_VALUE;
            this.durationTest = 0;
            this.colorIdx = 0;
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        EmptyBorder margin2 = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        VerticalPanel settingsPane = new VerticalPanel();
        settingsPane.setBorder(margin2);
        this.graphPanel = new RespTimeGraphChart();
        this.graphPanel.setPreferredSize(new Dimension(400, 300));
        settingsPane.add(this.createGraphActionsPane());
        settingsPane.add(this.createGraphSettingsPane());
        settingsPane.add(this.createGraphTitlePane());
        settingsPane.add(this.createLinePane());
        settingsPane.add(this.createGraphDimensionPane());
        JPanel axisPane = new JPanel(new BorderLayout());
        axisPane.add((Component)this.createGraphXAxisPane(), "West");
        axisPane.add((Component)this.createGraphYAxisPane(), "Center");
        settingsPane.add(axisPane);
        settingsPane.add(this.createLegendPane());
        this.tabbedGraph.addTab(JMeterUtils.getResString((String)"aggregate_graph_tab_settings"), (Component)settingsPane);
        this.tabbedGraph.addTab(JMeterUtils.getResString((String)"aggregate_graph_tab_graph"), this.graphPanel);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int index;
                JTabbedPane srcTab = (JTabbedPane)changeEvent.getSource();
                if (srcTab.getTitleAt(index = srcTab.getSelectedIndex()).equals(JMeterUtils.getResString((String)"aggregate_graph_tab_graph"))) {
                    RespTimeGraphVisualizer.this.actionMakeGraph();
                }
            }
        };
        this.tabbedGraph.addChangeListener(changeListener);
        this.add(mainPanel, "North");
        this.add(this.tabbedGraph, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        boolean forceReloadData = false;
        Object eventSource = event.getSource();
        if (eventSource == this.displayButton) {
            this.actionMakeGraph();
        } else if (eventSource == this.saveGraph) {
            this.saveGraphToFile = true;
            try {
                ActionRouter.getInstance().getAction("save_graphics", SaveGraphics.class.getName()).doAction(new ActionEvent(this, 1, "save_graphics"));
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        } else if (eventSource == this.syncWithName) {
            this.graphTitle.setText(this.namePanel.getName());
        } else if (eventSource == this.dynamicGraphSize) {
            if (this.dynamicGraphSize.isSelected()) {
                this.graphWidth.setEnabled(false);
                this.graphHeight.setEnabled(false);
            } else {
                this.graphWidth.setEnabled(true);
                this.graphHeight.setEnabled(true);
            }
        } else if (eventSource == this.samplerSelection) {
            if (this.samplerSelection.isSelected()) {
                this.samplerMatchLabel.setEnabled(true);
                this.applyFilterBtn.setEnabled(true);
                this.caseChkBox.setEnabled(true);
                this.regexpChkBox.setEnabled(true);
            } else {
                this.samplerMatchLabel.setEnabled(false);
                this.applyFilterBtn.setEnabled(false);
                this.caseChkBox.setEnabled(false);
                this.regexpChkBox.setEnabled(false);
                forceReloadData = true;
            }
        }
        if (eventSource == this.applyFilterBtn || eventSource == this.intervalButton || forceReloadData) {
            if (eventSource == this.intervalButton) {
                this.intervalValue = Integer.parseInt(this.intervalField.getText());
            }
            if (eventSource == this.applyFilterBtn && this.samplerSelection.isSelected() && this.samplerMatchLabel.getText() != null && this.samplerMatchLabel.getText().length() > 0) {
                this.pattern = this.createPattern(this.samplerMatchLabel.getText());
            } else if (forceReloadData) {
                this.pattern = null;
                this.matcher = null;
            }
            if (this.getFile() != null && this.getFile().length() > 0) {
                this.clearData();
                FilePanel filePanel = (FilePanel)this.getFilePanel();
                filePanel.actionPerformed(event);
            } else if (this.internalList.size() >= 2) {
                Object object = this.lockInterval;
                synchronized (object) {
                    ArrayList<RespTimeGraphDataBean> tempList = new ArrayList<RespTimeGraphDataBean>();
                    tempList.addAll(this.internalList);
                    this.clearData();
                    for (RespTimeGraphDataBean data : tempList) {
                        SampleResult sr = new SampleResult(data.getStartTime(), data.getTime());
                        sr.setSampleLabel(data.getSamplerLabel());
                        this.add(sr);
                    }
                }
            }
        }
    }

    private void actionMakeGraph() {
        String msgErr = null;
        this.durationTest = this.maxStartTime - this.minStartTime;
        if (this.seriesNames.size() <= 0) {
            msgErr = JMeterUtils.getResString((String)"aggregate_graph_no_values_to_graph");
        } else if (this.durationTest < 1) {
            msgErr = JMeterUtils.getResString((String)"graph_resp_time_not_enough_data");
        }
        if (msgErr == null) {
            this.makeGraph();
            this.tabbedGraph.setSelectedIndex(1);
        } else {
            JOptionPane.showMessageDialog(null, msgErr, msgErr, 2);
        }
    }

    public JComponent getPrintableComponent() {
        if (this.saveGraphToFile) {
            this.saveGraphToFile = false;
            this.graphPanel.setBounds(this.graphPanel.getLocation().x, this.graphPanel.getLocation().y, this.graphPanel.width, this.graphPanel.height);
            return this.graphPanel;
        }
        return this;
    }

    private JPanel createGraphActionsPane() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel displayPane = new JPanel();
        displayPane.add(this.displayButton);
        this.displayButton.addActionListener(this);
        buttonPanel.add((Component)displayPane, "West");
        JPanel savePane = new JPanel();
        savePane.add(this.saveGraph);
        this.saveGraph.addActionListener(this);
        this.syncWithName.addActionListener(this);
        buttonPanel.add((Component)savePane, "East");
        return buttonPanel;
    }

    public String[] getXAxisLabels() {
        SimpleDateFormat formatter = new SimpleDateFormat(this.xAxisTimeFormat.getText());
        String[] xAxisLabels = new String[this.durationTest];
        for (int j = 0; j < this.durationTest; ++j) {
            xAxisLabels[j] = formatter.format(new Date((this.minStartTime + j) * this.intervalValue));
        }
        return xAxisLabels;
    }

    private String[] getLegendLabels() {
        String[] legends = new String[this.seriesNames.size()];
        int i = 0;
        for (Map.Entry<String, RespTimeGraphLineBean> entry : this.seriesNames.entrySet()) {
            RespTimeGraphLineBean val = entry.getValue();
            legends[i] = val.getLabel();
            ++i;
        }
        return legends;
    }

    private Color[] getLinesColors() {
        Color[] linesColors = new Color[this.seriesNames.size()];
        int i = 0;
        for (Map.Entry<String, RespTimeGraphLineBean> entry : this.seriesNames.entrySet()) {
            RespTimeGraphLineBean val = entry.getValue();
            linesColors[i] = val.getLineColor();
            ++i;
        }
        return linesColors;
    }

    private JPanel createGraphSettingsPane() {
        JPanel settingsPane = new JPanel(new BorderLayout());
        settingsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"graph_resp_time_settings_pane")));
        JPanel intervalPane = new JPanel();
        intervalPane.setLayout(new FlowLayout(0, 0, 0));
        this.intervalField.setText(String.valueOf(10000));
        intervalPane.add((Component)this.intervalField);
        this.intervalButton.setFont(this.FONT_SMALL);
        this.intervalButton.addActionListener(this);
        intervalPane.add(this.intervalButton);
        settingsPane.add((Component)intervalPane, "North");
        settingsPane.add((Component)this.createGraphSelectionSubPane(), "South");
        return settingsPane;
    }

    private JPanel createGraphSelectionSubPane() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        searchPanel.add(this.samplerSelection);
        this.samplerMatchLabel.setEnabled(false);
        this.applyFilterBtn.setEnabled(false);
        this.caseChkBox.setEnabled(false);
        this.regexpChkBox.setEnabled(false);
        this.samplerSelection.addActionListener(this);
        searchPanel.add(this.samplerMatchLabel);
        searchPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.applyFilterBtn.setFont(this.FONT_SMALL);
        this.applyFilterBtn.addActionListener(this);
        searchPanel.add(this.applyFilterBtn);
        this.caseChkBox.setFont(this.FONT_SMALL);
        searchPanel.add(this.caseChkBox);
        this.regexpChkBox.setFont(this.FONT_SMALL);
        searchPanel.add(this.regexpChkBox);
        return searchPanel;
    }

    private JPanel createGraphTitlePane() {
        JPanel titleNamePane = new JPanel(new BorderLayout());
        this.syncWithName.setFont(this.FONT_SMALL);
        titleNamePane.add((Component)this.graphTitle, "Center");
        titleNamePane.add((Component)this.syncWithName, "East");
        JPanel titleStylePane = new JPanel();
        titleStylePane.setLayout(new FlowLayout(0, 0, 5));
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_font"), (JComboBox)this.titleFontNameList));
        this.titleFontNameList.setSelectedIndex(0);
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_size"), (JComboBox)this.titleFontSizeList));
        this.titleFontSizeList.setSelectedItem(StatGraphProperties.fontSize[6]);
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_style"), (JComboBox)this.titleFontStyleList));
        this.titleFontStyleList.setSelectedItem(JMeterUtils.getResString((String)"fontstyle.bold"));
        JPanel titlePane = new JPanel(new BorderLayout());
        titlePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_title_group")));
        titlePane.add((Component)titleNamePane, "North");
        titlePane.add((Component)titleStylePane, "South");
        return titlePane;
    }

    private JPanel createLinePane() {
        JPanel lineStylePane = new JPanel();
        lineStylePane.setLayout(new FlowLayout(0, 0, 0));
        lineStylePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"graph_resp_time_settings_line")));
        lineStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"graph_resp_time_stroke_width"), (JComboBox)this.strokeWidthList));
        this.strokeWidthList.setSelectedItem(StatGraphProperties.strokeWidth[4]);
        lineStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"graph_resp_time_shape_label"), (JComboBox)this.pointShapeLine));
        this.pointShapeLine.setSelectedIndex(0);
        return lineStylePane;
    }

    private JPanel createGraphDimensionPane() {
        JPanel dimensionPane = new JPanel();
        dimensionPane.setLayout(new FlowLayout(0, 0, 0));
        dimensionPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_dimension")));
        dimensionPane.add(this.dynamicGraphSize);
        this.dynamicGraphSize.setSelected(true);
        this.graphWidth.setEnabled(false);
        this.graphHeight.setEnabled(false);
        this.dynamicGraphSize.addActionListener(this);
        dimensionPane.add(Box.createRigidArea(new Dimension(10, 0)));
        dimensionPane.add((Component)this.graphWidth);
        dimensionPane.add(Box.createRigidArea(new Dimension(5, 0)));
        dimensionPane.add((Component)this.graphHeight);
        return dimensionPane;
    }

    private JPanel createGraphXAxisPane() {
        JPanel xAxisPane = new JPanel();
        xAxisPane.setLayout(new FlowLayout(0, 0, 0));
        xAxisPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_xaxis_group")));
        this.xAxisTimeFormat.setText("HH:mm:ss");
        xAxisPane.add((Component)this.xAxisTimeFormat);
        return xAxisPane;
    }

    private JPanel createGraphYAxisPane() {
        JPanel yAxisPane = new JPanel();
        yAxisPane.setLayout(new FlowLayout(0, 0, 0));
        yAxisPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_yaxis_group")));
        yAxisPane.add((Component)this.maxValueYAxisLabel);
        yAxisPane.add(this.numberShowGrouping);
        return yAxisPane;
    }

    private JPanel createLegendPane() {
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new FlowLayout(0, 0, 0));
        legendPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_legend")));
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_legend_placement"), (JComboBox)this.legendPlacementList));
        this.legendPlacementList.setSelectedItem(JMeterUtils.getResString((String)"aggregate_graph_legend.placement.bottom"));
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_font"), (JComboBox)this.fontNameList));
        this.fontNameList.setSelectedIndex(0);
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_size"), (JComboBox)this.fontSizeList));
        this.fontSizeList.setSelectedItem(StatGraphProperties.fontSize[2]);
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_style"), (JComboBox)this.fontStyleList));
        this.fontStyleList.setSelectedItem(JMeterUtils.getResString((String)"fontstyle.normal"));
        return legendPanel;
    }

    private Pattern createPattern(String textToFind) {
        String textToFindQ = Pattern.quote(textToFind);
        if (this.regexpChkBox.isSelected()) {
            textToFindQ = textToFind;
        }
        Pattern pattern = null;
        try {
            pattern = this.caseChkBox.isSelected() ? Pattern.compile(textToFindQ) : Pattern.compile(textToFindQ, 2);
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
        return pattern;
    }
}

