/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.writers;

import java.io.File;
import java.util.Calendar;
import org.apache.jmeter.report.writers.ReportSummary;
import org.apache.jmeter.report.writers.ReportWriter;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;

public abstract class AbstractReportWriter
extends AbstractTestElement
implements ReportWriter {
    private static final long serialVersionUID = 240L;
    public static final String TARGET_DIRECTORY = "ReportWriter.target.directory";

    public abstract ReportSummary writeReport(TestElement var1);

    public String getTargetDirectory() {
        return this.getPropertyAsString(TARGET_DIRECTORY);
    }

    public void setTargetDirectory(String directory) {
        this.setProperty(TARGET_DIRECTORY, directory);
    }

    public void makeDirectory() {
        File output = new File(this.getTargetDirectory());
        if (!(output.exists() && output.isDirectory() || output.mkdir())) {
            throw new IllegalStateException("Could not create directory:" + output.getAbsolutePath());
        }
    }

    public void archiveDirectory() {
        File output = new File(this.getTargetDirectory());
        if (output.exists() && output.isDirectory() && !output.renameTo(new File("archive." + this.getDayString()))) {
            throw new IllegalStateException("Could not rename directory:" + output.getAbsolutePath() + " to archive." + this.getDayString());
        }
    }

    public String getDayString() {
        Calendar today = Calendar.getInstance();
        String year = String.valueOf(today.get(1));
        String month = String.valueOf(today.get(2));
        String day = String.valueOf(today.get(5));
        return year + month + day;
    }
}

