/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPlan
extends AbstractTestElement
implements Serializable,
TestStateListener {
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String REPORT_PAGE = "ReportPlan.report_page";
    public static final String USER_DEFINED_VARIABLES = "ReportPlan.user_defined_variables";
    public static final String REPORT_COMMENTS = "ReportPlan.comments";
    public static final String BASEDIR = "ReportPlan.basedir";
    private transient List<AbstractThreadGroup> reportPages = new LinkedList<AbstractThreadGroup>();
    private transient List<ConfigElement> configs = new LinkedList<ConfigElement>();
    private static final List<String> itemsCanAdd = new LinkedList<String>();
    private static volatile boolean functionalMode = false;

    public ReportPlan() {
        this(JMeterUtils.getResString((String)"report_plan"));
    }

    public ReportPlan(String name) {
        this.setName(name);
        this.setProperty((JMeterProperty)new CollectionProperty(REPORT_PAGE, this.reportPages));
    }

    public void setUserDefinedVariables(Arguments vars) {
        this.setProperty((JMeterProperty)new TestElementProperty(USER_DEFINED_VARIABLES, (TestElement)vars));
    }

    public String getBasedir() {
        return this.getPropertyAsString(BASEDIR);
    }

    public void setBasedir(String b) {
        this.setProperty(BASEDIR, b);
    }

    public Map<String, String> getUserDefinedVariables() {
        Arguments args = this.getVariables();
        return args.getArgumentsAsMap();
    }

    private Arguments getVariables() {
        Arguments args = (Arguments)this.getProperty(USER_DEFINED_VARIABLES).getObjectValue();
        if (args == null) {
            args = new Arguments();
            this.setUserDefinedVariables(args);
        }
        return args;
    }

    public static boolean getFunctionalMode() {
        return functionalMode;
    }

    public void addParameter(String name, String value) {
        this.getVariables().addArgument(name, value);
    }

    public void addTestElement(TestElement tg) {
        super.addTestElement(tg);
        if (tg instanceof AbstractThreadGroup && !this.isRunningVersion()) {
            this.addReportPage((AbstractThreadGroup)tg);
        }
    }

    public void addJMeterComponent(TestElement child) {
        if (child instanceof AbstractThreadGroup) {
            this.addReportPage((AbstractThreadGroup)child);
        }
    }

    public Collection<AbstractThreadGroup> getReportPages() {
        return this.reportPages;
    }

    public void addConfigElement(ConfigElement c) {
        this.configs.add(c);
    }

    public void addReportPage(AbstractThreadGroup group) {
        this.reportPages.add(group);
    }

    public void testEnded() {
        try {
            FileServer.getFileServer().closeFiles();
        }
        catch (IOException e) {
            log.error("Problem closing files at end of test", (Throwable)e);
        }
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testStarted() {
        if (this.getBasedir() != null && this.getBasedir().length() > 0) {
            try {
                FileServer.getFileServer().setBasedir(FileServer.getFileServer().getBaseDir() + this.getBasedir());
            }
            catch (IllegalStateException e) {
                log.error("Failed to set file server base dir with " + this.getBasedir(), (Throwable)e);
            }
        }
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    static {
        itemsCanAdd.add(JMeterUtils.getResString((String)"report_page"));
    }
}

