/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileToString
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__FileToString";
    static final String ERR_IND = "**ERR**";
    private static final int MIN_PARAM_COUNT = 1;
    private static final int MAX_PARAM_COUNT = 3;
    private static final int ENCODING = 2;
    private static final int PARAM_NAME = 3;
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String fileName = ((CompoundVariable)this.values[0]).execute();
        String encoding = null;
        if (this.values.length >= 2 && (encoding = ((CompoundVariable)this.values[1]).execute().trim()).length() <= 0) {
            encoding = null;
        }
        String myName = "";
        if (this.values.length >= 3) {
            myName = ((CompoundVariable)this.values[2]).execute().trim();
        }
        String myValue = ERR_IND;
        try {
            myValue = FileUtils.readFileToString((File)new File(fileName), (String)encoding);
        }
        catch (IOException e) {
            log.warn("Could not read file: " + fileName + " " + e.getMessage(), (Throwable)e);
            throw new JMeterStopThreadException("End of sequence", (Throwable)e);
        }
        if (myName.length() > 0 && (vars = this.getVariables()) != null) {
            vars.put(myName, myValue);
        }
        if (log.isDebugEnabled()) {
            String tn = Thread.currentThread().getName();
            log.debug(tn + " name:" + myName + " value:" + myValue);
        }
        return myValue;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"string_from_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"string_from_file_encoding"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

