/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.RunTime;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class RunTimeGui
extends AbstractControllerGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JTextField seconds;
    private boolean displayName = true;

    public RunTimeGui() {
        this(true);
    }

    public RunTimeGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
        this.setState(1L);
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof RunTime) {
            this.setState(((RunTime)element).getRuntimeString());
        } else {
            this.setState(1L);
        }
    }

    public TestElement createTestElement() {
        RunTime lc = new RunTime();
        this.modifyTestElement(lc);
        return lc;
    }

    public void modifyTestElement(TestElement lc) {
        this.configureTestElement(lc);
        if (lc instanceof RunTime) {
            if (this.seconds.getText().length() > 0) {
                ((RunTime)lc).setRuntime(this.seconds.getText());
            } else {
                ((RunTime)lc).setRuntime(0L);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.seconds.setText("1");
    }

    public void actionPerformed(ActionEvent event) {
        this.seconds.setEnabled(true);
    }

    public String getLabelResource() {
        return "runtime_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createLoopCountPanel(), "North");
            this.add((Component)mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createLoopCountPanel(), "North");
        }
    }

    private JPanel createLoopCountPanel() {
        JPanel loopPanel = new JPanel(new BorderLayout(5, 0));
        JLabel secondsLabel = new JLabel(JMeterUtils.getResString("runtime_seconds"));
        loopPanel.add((Component)secondsLabel, "West");
        JPanel loopSubPanel = new JPanel(new BorderLayout(5, 0));
        this.seconds = new JTextField("1", 5);
        secondsLabel.setLabelFor(this.seconds);
        loopSubPanel.add((Component)this.seconds, "Center");
        loopPanel.add((Component)loopSubPanel, "Center");
        loopPanel.add(Box.createHorizontalStrut(secondsLabel.getPreferredSize().width + this.seconds.getPreferredSize().width), "North");
        return loopPanel;
    }

    private void setState(String secsCount) {
        this.seconds.setText(secsCount);
        this.seconds.setEnabled(true);
    }

    private void setState(long secsCount) {
        this.seconds.setEnabled(true);
        this.seconds.setText(Long.toString(secsCount));
    }
}

