/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.LoggerPanel;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.LoadDraggedFile;
import org.apache.jmeter.gui.tree.JMeterCellRenderer;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.gui.util.JMeterToolBar;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class MainFrame
extends JFrame
implements TestStateListener,
Remoteable,
DropTargetListener,
Clearable,
ActionListener {
    private static final long serialVersionUID = 240L;
    private static final String LOCAL = "*local*";
    private static final String DEFAULT_APP_NAME = "Apache JMeter";
    private static final String DEFAULT_TITLE = "Apache JMeter (" + JMeterUtils.getJMeterVersion() + ")";
    private static final boolean DISPLAY_TOOLBAR = JMeterUtils.getPropDefault("jmeter.toolbar.display", true);
    private static final boolean DISPLAY_LOGGER_PANEL = JMeterUtils.getPropDefault("jmeter.loggerpanel.display", false);
    private static final boolean DISPLAY_ERROR_FATAL_COUNTER = JMeterUtils.getPropDefault("jmeter.errorscounter.display", true);
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JMeterMenuBar menuBar;
    private JScrollPane mainPanel;
    private JScrollPane treePanel;
    private LoggerPanel logPanel;
    private JTree tree;
    private final ImageIcon runningIcon = JMeterUtils.getImage("thread.enabled.gif");
    private final ImageIcon stoppedIcon = JMeterUtils.getImage("thread.disabled.gif");
    private final ImageIcon warningIcon = JMeterUtils.getImage("warning.png");
    private JButton runningIndicator;
    private int previousDragXLocation = 0;
    private int previousDragYLocation = 0;
    private final Set<String> hosts = new HashSet<String>();
    private JDialog stoppingMessage;
    private JLabel totalThreads;
    private JLabel activeThreads;
    private JMeterToolBar toolbar;
    private JButton warnIndicator;
    private JLabel errorsOrFatalsLabel;
    private transient ErrorsAndFatalsCounterLogTarget errorsAndFatalsCounterLogTarget;

    public MainFrame(TreeModel treeModel, JMeterTreeListener treeListener) {
        this.runningIndicator = new JButton(this.stoppedIcon);
        this.runningIndicator.setMargin(new Insets(0, 0, 0, 0));
        this.runningIndicator.setBorder(BorderFactory.createEmptyBorder());
        this.totalThreads = new JLabel("0");
        this.activeThreads = new JLabel("0");
        this.warnIndicator = new JButton(this.warningIcon);
        this.warnIndicator.setMargin(new Insets(0, 0, 0, 0));
        this.warnIndicator.setOpaque(false);
        this.warnIndicator.setContentAreaFilled(false);
        this.warnIndicator.setBorderPainted(false);
        this.warnIndicator.setToolTipText(JMeterUtils.getResString("error_indicator_tooltip"));
        this.warnIndicator.addActionListener(this);
        this.errorsOrFatalsLabel = new JLabel("0");
        this.errorsOrFatalsLabel.setToolTipText(JMeterUtils.getResString("error_indicator_tooltip"));
        this.tree = this.makeTree(treeModel, treeListener);
        GuiPackage.getInstance().setMainFrame(this);
        this.init();
        this.initTopLevelDndHandler();
        this.setDefaultCloseOperation(0);
    }

    @Deprecated
    public MainFrame() {
    }

    public void setFileLoadEnabled(boolean enabled) {
        this.menuBar.setFileLoadEnabled(enabled);
    }

    public void setFileSaveEnabled(boolean enabled) {
        this.menuBar.setFileSaveEnabled(enabled);
    }

    public void setFileRevertEnabled(boolean enabled) {
        this.menuBar.setFileRevertEnabled(enabled);
    }

    public void setProjectFileLoaded(String file) {
        this.menuBar.setProjectFileLoaded(file);
    }

    public void setEditMenu(JPopupMenu menu) {
        this.menuBar.setEditMenu(menu);
    }

    public void setEditEnabled(boolean enabled) {
        this.menuBar.setEditEnabled(enabled);
    }

    public void setEditAddMenu(JMenu menu) {
        this.menuBar.setEditAddMenu(menu);
    }

    public void setEditAddEnabled(boolean enabled) {
        this.menuBar.setEditAddEnabled(enabled);
    }

    public void closeMenu() {
        MenuElement[] menuElement;
        if (this.menuBar.isSelected() && (menuElement = this.menuBar.getSubElements()) != null) {
            for (int i = 0; i < menuElement.length; ++i) {
                JMenu menu = (JMenu)menuElement[i];
                if (!menu.isSelected()) continue;
                menu.setPopupMenuVisible(false);
                menu.setSelected(false);
                break;
            }
        }
    }

    public void showStoppingMessage(String host) {
        if (this.stoppingMessage != null) {
            this.stoppingMessage.dispose();
        }
        this.stoppingMessage = new EscapeDialog(this, JMeterUtils.getResString("stopping_test_title"), true);
        JLabel stopLabel = new JLabel(JMeterUtils.getResString("stopping_test") + ": " + host);
        stopLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.stoppingMessage.getContentPane().add(stopLabel);
        this.stoppingMessage.pack();
        ComponentUtil.centerComponentInComponent((Component)this, (Component)this.stoppingMessage);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MainFrame.this.stoppingMessage != null) {
                    MainFrame.this.stoppingMessage.setVisible(true);
                }
            }
        });
    }

    public void updateCounts() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.activeThreads.setText(Integer.toString(JMeterContextService.getNumberOfThreads()));
                MainFrame.this.totalThreads.setText(Integer.toString(JMeterContextService.getTotalThreads()));
            }
        });
    }

    public void setMainPanel(JComponent comp) {
        this.mainPanel.setViewportView(comp);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void testStarted() {
        this.testStarted(LOCAL);
        this.menuBar.setEnabled(true);
    }

    public void testStarted(String host) {
        this.hosts.add(host);
        this.runningIndicator.setIcon(this.runningIcon);
        this.activeThreads.setText("0");
        this.totalThreads.setText("0");
        this.menuBar.setRunning(true, host);
        this.toolbar.setTestStarted(true);
    }

    public void testEnded() {
        this.testEnded(LOCAL);
        this.menuBar.setEnabled(false);
    }

    public void testEnded(String host) {
        this.hosts.remove(host);
        if (this.hosts.size() == 0) {
            this.runningIndicator.setIcon(this.stoppedIcon);
            JMeterContextService.endTest();
        }
        this.menuBar.setRunning(false, host);
        this.toolbar.setTestStarted(false);
        if (this.stoppingMessage != null) {
            this.stoppingMessage.dispose();
            this.stoppingMessage = null;
        }
    }

    private void init() {
        this.menuBar = new JMeterMenuBar();
        this.setJMenuBar(this.menuBar);
        JPanel all = new JPanel(new BorderLayout());
        all.add(this.createToolBar(), "North");
        JSplitPane treeAndMain = new JSplitPane(1);
        this.treePanel = this.createTreePanel();
        treeAndMain.setLeftComponent(this.treePanel);
        JSplitPane topAndDown = new JSplitPane(0);
        topAndDown.setOneTouchExpandable(true);
        topAndDown.setDividerLocation(0.8);
        topAndDown.setResizeWeight(0.8);
        topAndDown.setContinuousLayout(true);
        topAndDown.setBorder(null);
        if (!DISPLAY_LOGGER_PANEL) {
            topAndDown.setDividerSize(0);
        }
        this.mainPanel = this.createMainPanel();
        this.logPanel = this.createLoggerPanel();
        if (DISPLAY_ERROR_FATAL_COUNTER) {
            this.errorsAndFatalsCounterLogTarget = new ErrorsAndFatalsCounterLogTarget();
            LoggingManager.addLogTargetToRootLogger((LogTarget[])new LogTarget[]{this.logPanel, this.errorsAndFatalsCounterLogTarget});
        } else {
            LoggingManager.addLogTargetToRootLogger((LogTarget[])new LogTarget[]{this.logPanel});
        }
        topAndDown.setTopComponent(this.mainPanel);
        topAndDown.setBottomComponent(this.logPanel);
        treeAndMain.setRightComponent(topAndDown);
        treeAndMain.setResizeWeight(0.2);
        treeAndMain.setContinuousLayout(true);
        all.add((Component)treeAndMain, "Center");
        this.getContentPane().add(all);
        this.tree.setSelectionRow(1);
        this.addWindowListener(new WindowHappenings());
        this.setTitle(DEFAULT_TITLE);
        this.setIconImage(JMeterUtils.getImage("jmeter.jpg").getImage());
        this.setWindowTitle();
    }

    public void initTopLevelDndHandler() {
        new DropTarget(this, this);
    }

    public void setExtendedFrameTitle(String fname) {
        if (fname == null) {
            this.setTitle(DEFAULT_TITLE);
            return;
        }
        String temp = fname.replace('\\', '/');
        String simpleName = temp.substring(temp.lastIndexOf(47) + 1);
        this.setTitle(simpleName + " (" + fname + ") - " + DEFAULT_TITLE);
    }

    private Component createToolBar() {
        Box toolPanel = new Box(0);
        this.toolbar = JMeterToolBar.createToolbar(DISPLAY_TOOLBAR);
        GuiPackage guiInstance = GuiPackage.getInstance();
        guiInstance.setMainToolbar(this.toolbar);
        guiInstance.getMenuItemToolbar().getModel().setSelected(DISPLAY_TOOLBAR);
        toolPanel.add(this.toolbar);
        toolPanel.add(Box.createRigidArea(new Dimension(10, 15)));
        toolPanel.add(Box.createGlue());
        if (DISPLAY_ERROR_FATAL_COUNTER) {
            toolPanel.add(this.errorsOrFatalsLabel);
            toolPanel.add(this.warnIndicator);
            toolPanel.add(Box.createRigidArea(new Dimension(20, 15)));
        }
        toolPanel.add(this.activeThreads);
        toolPanel.add(new JLabel(" / "));
        toolPanel.add(this.totalThreads);
        toolPanel.add(Box.createRigidArea(new Dimension(10, 15)));
        toolPanel.add(this.runningIndicator);
        return toolPanel;
    }

    private JScrollPane createTreePanel() {
        JScrollPane treeP = new JScrollPane(this.tree);
        treeP.setMinimumSize(new Dimension(100, 0));
        return treeP;
    }

    private JScrollPane createMainPanel() {
        return new JScrollPane();
    }

    private LoggerPanel createLoggerPanel() {
        LoggerPanel loggerPanel = new LoggerPanel();
        loggerPanel.setMinimumSize(new Dimension(0, 100));
        loggerPanel.setPreferredSize(new Dimension(0, 150));
        GuiPackage guiInstance = GuiPackage.getInstance();
        guiInstance.setLoggerPanel(loggerPanel);
        guiInstance.getMenuItemLoggerPanel().getModel().setSelected(DISPLAY_LOGGER_PANEL);
        loggerPanel.setVisible(DISPLAY_LOGGER_PANEL);
        return loggerPanel;
    }

    private JTree makeTree(TreeModel treeModel, JMeterTreeListener treeListener) {
        JTree treevar = new JTree(treeModel){
            private static final long serialVersionUID = 240L;

            public String getToolTipText(MouseEvent event) {
                String comment;
                Object testElement;
                Object treeNode;
                TreePath path = this.getPathForLocation(event.getX(), event.getY());
                if (path != null && (treeNode = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (testElement = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof TestElement && (comment = ((TestElement)testElement).getComment()) != null && comment.length() > 0) {
                    return comment;
                }
                return null;
            }
        };
        treevar.setToolTipText("");
        treevar.setCellRenderer(this.getCellRenderer());
        treevar.setRootVisible(false);
        treevar.setShowsRootHandles(true);
        treeListener.setJTree(treevar);
        treevar.addTreeSelectionListener(treeListener);
        treevar.addMouseListener(treeListener);
        treevar.addMouseMotionListener(treeListener);
        treevar.addKeyListener(treeListener);
        return treevar;
    }

    private TreeCellRenderer getCellRenderer() {
        JMeterCellRenderer rend = new JMeterCellRenderer();
        rend.setFont(new Font("Dialog", 0, 11));
        return rend;
    }

    public void drawDraggedComponent(Component dragIcon, int x, int y) {
        Dimension size = dragIcon.getPreferredSize();
        this.treePanel.paintImmediately(this.previousDragXLocation, this.previousDragYLocation, size.width, size.height);
        this.getLayeredPane().setLayer(dragIcon, 400);
        SwingUtilities.paintComponent(this.treePanel.getGraphics(), dragIcon, this.treePanel, x, y, size.width, size.height);
        this.previousDragXLocation = x;
        this.previousDragYLocation = y;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                dtde.acceptDrop(3);
                try {
                    List files = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                    if (files.isEmpty()) {
                        return;
                    }
                    File file = (File)files.get(0);
                    if (!file.getName().endsWith(".jmx")) {
                        log.warn("Importing file:" + file.getName() + "from DnD failed because file extension does not end with .jmx");
                        return;
                    }
                    ActionEvent fakeEvent = new ActionEvent(this, 1001, "open");
                    LoadDraggedFile.loadProject(fakeEvent, file);
                }
                finally {
                    dtde.dropComplete(true);
                }
                return;
            }
        }
        catch (UnsupportedFlavorException e) {
            log.warn("Dnd failed", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Dnd failed", (Throwable)e);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void clearData() {
        this.logPanel.clear();
        if (DISPLAY_ERROR_FATAL_COUNTER) {
            this.errorsAndFatalsCounterLogTarget.clearData();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.warnIndicator) {
            ActionRouter.getInstance().doActionNow(new ActionEvent(event.getSource(), event.getID(), "logger_panel_enable_disable"));
        }
    }

    private void setWindowTitle() {
        Class<?> xtoolkit = Toolkit.getDefaultToolkit().getClass();
        if (xtoolkit.getName().equals("sun.awt.X11.XToolkit")) {
            try {
                Field awtAppClassName = xtoolkit.getDeclaredField("awtAppClassName");
                awtAppClassName.setAccessible(true);
                awtAppClassName.set(null, DEFAULT_APP_NAME);
            }
            catch (NoSuchFieldException nsfe) {
                log.warn("Error awt title: " + nsfe);
            }
            catch (IllegalAccessException iae) {
                log.warn("Error awt title: " + iae);
            }
        }
    }

    public final class ErrorsAndFatalsCounterLogTarget
    implements LogTarget,
    Clearable {
        public AtomicInteger errorOrFatal = new AtomicInteger(0);

        public void processEvent(LogEvent event) {
            if (event.getPriority().equals(Priority.ERROR) || event.getPriority().equals(Priority.FATAL_ERROR)) {
                final int newValue = this.errorOrFatal.incrementAndGet();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.this.errorsOrFatalsLabel.setText(Integer.toString(newValue));
                    }
                });
            }
        }

        public void clearData() {
            this.errorOrFatal.set(0);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.errorsOrFatalsLabel.setText(Integer.toString(ErrorsAndFatalsCounterLogTarget.this.errorOrFatal.get()));
                }
            });
        }
    }

    private static class WindowHappenings
    extends WindowAdapter {
        private WindowHappenings() {
        }

        public void windowClosing(WindowEvent event) {
            ActionRouter.getInstance().actionPerformed(new ActionEvent(this, event.getID(), "exit"));
        }
    }
}

