/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeParent
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        String name = ((Component)e.getSource()).getName();
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode currentNode = guiPackage.getTreeListener().getCurrentNode();
        if (!(currentNode.getUserObject() instanceof Controller)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            guiPackage.updateCurrentNode();
            TestElement controller = guiPackage.createTestElement(name);
            this.changeParent(controller, guiPackage, currentNode);
        }
        catch (Exception err) {
            Toolkit.getDefaultToolkit().beep();
            log.error("Failed to change parent", (Throwable)err);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    private void changeParent(TestElement newParent, GuiPackage guiPackage, JMeterTreeNode currentNode) {
        JMeterTreeModel treeModel = guiPackage.getTreeModel();
        JMeterTreeNode newNode = new JMeterTreeNode(newParent, treeModel);
        JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
        int index = parentNode.getIndex(currentNode);
        treeModel.insertNodeInto(newNode, parentNode, index);
        treeModel.removeNodeFromParent(currentNode);
        int childCount = currentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            JMeterTreeNode node = (JMeterTreeNode)currentNode.getChildAt(0);
            treeModel.removeNodeFromParent(node);
            treeModel.insertNodeInto(node, newNode, newNode.getChildCount());
        }
    }

    static {
        commands.add("Change Parent");
    }
}

