/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.util.JMeterUtils;

public class ScopePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private final JRadioButton parentButton;
    private final JRadioButton childButton;
    private final JRadioButton allButton = new JRadioButton(JMeterUtils.getResString("sample_scope_all"));
    private final JRadioButton variableButton;
    private final JTextField variableName;

    public ScopePanel() {
        this(false);
    }

    public ScopePanel(boolean enableVariableButton) {
        this.parentButton = new JRadioButton(JMeterUtils.getResString("sample_scope_parent"));
        this.childButton = new JRadioButton(JMeterUtils.getResString("sample_scope_children"));
        if (enableVariableButton) {
            this.variableButton = new JRadioButton(JMeterUtils.getResString("sample_scope_variable"));
            this.variableName = new JTextField(10);
        } else {
            this.variableButton = null;
            this.variableName = null;
        }
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("sample_scope")));
        this.parentButton.setSelected(true);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        ButtonGroup group = new ButtonGroup();
        group.add(this.allButton);
        group.add(this.parentButton);
        group.add(this.childButton);
        ((Container)buttonPanel).add(this.parentButton);
        ((Container)buttonPanel).add(this.childButton);
        ((Container)buttonPanel).add(this.allButton);
        if (this.variableButton != null) {
            this.variableButton.addActionListener(this);
            group.add(this.variableButton);
            ((Container)buttonPanel).add(this.variableButton);
            ((Container)buttonPanel).add(this.variableName);
        }
        this.add(buttonPanel);
    }

    public void clearGui() {
        this.parentButton.setSelected(true);
    }

    public int getSelection() {
        if (this.parentButton.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setScopeAll() {
        this.setScopeAll(false);
    }

    public void setScopeAll(boolean enableVariableButton) {
        this.allButton.setSelected(true);
        if (enableVariableButton) {
            this.variableName.setText("");
        }
    }

    public void setScopeChildren() {
        this.setScopeChildren(false);
    }

    public void setScopeChildren(boolean enableVariableButton) {
        this.childButton.setSelected(true);
        if (enableVariableButton) {
            this.variableName.setText("");
        }
    }

    public void setScopeParent() {
        this.setScopeParent(false);
    }

    public void setScopeParent(boolean enableVariableButton) {
        this.parentButton.setSelected(true);
        if (enableVariableButton) {
            this.variableName.setText("");
        }
    }

    public void setScopeVariable(String value) {
        this.variableButton.setSelected(true);
        this.variableName.setText(value);
    }

    public boolean isScopeParent() {
        return this.parentButton.isSelected();
    }

    public boolean isScopeChildren() {
        return this.childButton.isSelected();
    }

    public boolean isScopeAll() {
        return this.allButton.isSelected();
    }

    public boolean isScopeVariable() {
        return this.variableButton.isSelected();
    }

    public void actionPerformed(ActionEvent e) {
        this.variableName.setEnabled(this.variableButton.isSelected());
    }

    public String getVariable() {
        return this.variableName.getText();
    }
}

