/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.jmeter.util.SlowInputStream;
import org.apache.jmeter.util.SlowOutputStream;

public class SlowSSLSocket
extends SSLSocket {
    private final int CPS;
    private final SSLSocket sslSock;

    public SlowSSLSocket(SSLSocket sock, int cps) {
        if (cps <= 0) {
            throw new IllegalArgumentException("Speed (cps) <= 0");
        }
        this.sslSock = sock;
        this.CPS = cps;
    }

    public OutputStream getOutputStream() throws IOException {
        return new SlowOutputStream(this.sslSock.getOutputStream(), this.CPS);
    }

    public InputStream getInputStream() throws IOException {
        return new SlowInputStream(this.sslSock.getInputStream(), this.CPS);
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.sslSock.addHandshakeCompletedListener(arg0);
    }

    public boolean getEnableSessionCreation() {
        return this.sslSock.getEnableSessionCreation();
    }

    public String[] getEnabledCipherSuites() {
        return this.sslSock.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.sslSock.getEnabledProtocols();
    }

    public boolean getNeedClientAuth() {
        return this.sslSock.getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.sslSock.getSession();
    }

    public String[] getSupportedCipherSuites() {
        return this.sslSock.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.sslSock.getSupportedProtocols();
    }

    public boolean getUseClientMode() {
        return this.sslSock.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.sslSock.getWantClientAuth();
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.sslSock.removeHandshakeCompletedListener(arg0);
    }

    public void setEnableSessionCreation(boolean arg0) {
        this.sslSock.setEnableSessionCreation(arg0);
    }

    public void setEnabledCipherSuites(String[] arg0) {
        this.sslSock.setEnabledCipherSuites(arg0);
    }

    public void setEnabledProtocols(String[] arg0) {
        this.sslSock.setEnabledProtocols(arg0);
    }

    public void setNeedClientAuth(boolean arg0) {
        this.sslSock.setNeedClientAuth(arg0);
    }

    public void setUseClientMode(boolean arg0) {
        this.sslSock.setUseClientMode(arg0);
    }

    public void setWantClientAuth(boolean arg0) {
        this.sslSock.setWantClientAuth(arg0);
    }

    public void startHandshake() throws IOException {
        this.sslSock.startHandshake();
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.sslSock.bind(bindpoint);
    }

    public synchronized void close() throws IOException {
        this.sslSock.close();
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.sslSock.connect(endpoint, timeout);
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.sslSock.connect(endpoint);
    }

    public SocketChannel getChannel() {
        return this.sslSock.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.sslSock.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.sslSock.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.sslSock.getLocalAddress();
    }

    public int getLocalPort() {
        return this.sslSock.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.sslSock.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.sslSock.getOOBInline();
    }

    public int getPort() {
        return this.sslSock.getPort();
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.sslSock.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.sslSock.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.sslSock.getReuseAddress();
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return this.sslSock.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.sslSock.getSoLinger();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.sslSock.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.sslSock.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.sslSock.getTrafficClass();
    }

    public boolean isBound() {
        return this.sslSock.isBound();
    }

    public boolean isClosed() {
        return this.sslSock.isClosed();
    }

    public boolean isConnected() {
        return this.sslSock.isConnected();
    }

    public boolean isInputShutdown() {
        return this.sslSock.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.sslSock.isOutputShutdown();
    }

    public void sendUrgentData(int data) throws IOException {
        this.sslSock.sendUrgentData(data);
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.sslSock.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.sslSock.setOOBInline(on);
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.sslSock.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.sslSock.setReuseAddress(on);
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.sslSock.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.sslSock.setSoLinger(on, linger);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.sslSock.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.sslSock.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.sslSock.setTrafficClass(tc);
    }

    public void shutdownInput() throws IOException {
        this.sslSock.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.sslSock.shutdownOutput();
    }

    public String toString() {
        return this.sslSock.toString();
    }
}

