/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.Serializable;
import java.text.Format;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sample
implements Serializable,
Comparable<Sample> {
    private static final long serialVersionUID = 240L;
    private final long data;
    private final long average;
    private final long median;
    private final long distributionLine;
    private final long deviation;
    private final double throughput;
    private final long errorCount;
    private final boolean success;
    private final String label;
    private final String threadName;
    private final long count;
    private final long endTime;
    private final int bytes;

    public Sample(String name, long data, long average, long deviation, long median, long distributionLine, double throughput, long errorCount, boolean success, long num, long endTime) {
        this.data = data;
        this.average = average;
        this.deviation = deviation;
        this.throughput = throughput;
        this.success = success;
        this.median = median;
        this.distributionLine = distributionLine;
        this.label = name;
        this.errorCount = errorCount;
        this.count = num;
        this.endTime = endTime;
        this.bytes = 0;
        this.threadName = "";
    }

    public Sample(String name, long data, long average, long deviation, long median, long distributionLine, double throughput, long errorCount, boolean success, long num, long endTime, int bytes, String threadName) {
        this.data = data;
        this.average = average;
        this.deviation = deviation;
        this.throughput = throughput;
        this.success = success;
        this.median = median;
        this.distributionLine = distributionLine;
        this.label = name;
        this.errorCount = errorCount;
        this.count = num;
        this.endTime = endTime;
        this.bytes = bytes;
        this.threadName = threadName;
    }

    public Sample() {
        this(null, 0L, 0L, 0L, 0L, 0L, 0.0, 0L, true, 0L, 0L);
    }

    public int getBytes() {
        return this.bytes;
    }

    public long getAverage() {
        return this.average;
    }

    public long getCount() {
        return this.count;
    }

    public long getData() {
        return this.data;
    }

    public long getDeviation() {
        return this.deviation;
    }

    public long getDistributionLine() {
        return this.distributionLine;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public String getLabel() {
        return this.label;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getMedian() {
        return this.median;
    }

    public double getThroughput() {
        return this.throughput;
    }

    @Override
    public int compareTo(Sample o) {
        Sample oo = o;
        return this.count - oo.count < 0L ? -1 : (this.count == oo.count ? 0 : 1);
    }

    public boolean equals(Object o) {
        return o instanceof Sample && this.compareTo((Sample)o) == 0;
    }

    public int hashCode() {
        return (int)(this.count ^ this.count >>> 32);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.endTime - this.data;
    }

    public String getStartTimeFormatted(Format format) {
        return format.format(new Date(this.getStartTime()));
    }
}

