/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.engine.TreeClonerNoTimer;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Start
extends AbstractAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commands = new HashSet<String>();
    private StandardJMeterEngine engine;

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        if (e.getActionCommand().equals("start")) {
            this.popupShouldSave(e);
            this.startEngine(false);
        } else if (e.getActionCommand().equals("start_no_timers")) {
            this.popupShouldSave(e);
            this.startEngine(true);
        } else if (e.getActionCommand().equals("stop")) {
            if (this.engine != null) {
                log.info("Stopping test");
                GuiPackage.getInstance().getMainFrame().showStoppingMessage("");
                this.engine.stopTest();
            }
        } else if (e.getActionCommand().equals("shutdown") && this.engine != null) {
            log.info("Shutting test down");
            GuiPackage.getInstance().getMainFrame().showStoppingMessage("");
            this.engine.askThreadsToStop();
        }
    }

    private void startEngine(boolean ignoreTimer) {
        GuiPackage gui = GuiPackage.getInstance();
        HashTree testTree = gui.getTreeModel().getTestPlan();
        JMeter.convertSubTree(testTree);
        testTree.add(testTree.getArray()[0], (Object)gui.getMainFrame());
        log.debug("test plan before cloning is running version: " + ((TestPlan)testTree.getArray()[0]).isRunningVersion());
        TreeCloner cloner = this.cloneTree(testTree, ignoreTimer);
        this.engine = new StandardJMeterEngine();
        this.engine.configure((HashTree)cloner.getClonedTree());
        try {
            this.engine.runTest();
        }
        catch (JMeterEngineException e) {
            JOptionPane.showMessageDialog(gui.getMainFrame(), e.getMessage(), JMeterUtils.getResString("Error Occurred"), 0);
        }
        log.debug("test plan after cloning and running test is running version: " + ((TestPlan)testTree.getArray()[0]).isRunningVersion());
    }

    private TreeCloner cloneTree(HashTree testTree, boolean removeTimers) {
        TreeCloner cloner = null;
        cloner = removeTimers ? new TreeClonerNoTimer(false) : new TreeCloner(false);
        testTree.traverse((HashTreeTraverser)cloner);
        return cloner;
    }

    static {
        commands.add("start");
        commands.add("start_no_timers");
        commands.add("stop");
        commands.add("shutdown");
    }
}

