/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

public class FileListPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTable files = null;
    private transient ObjectTableModel tableModel = null;
    private static final String ACTION_BROWSE = "browse";
    private static final String LABEL_LIBRARY = "library";
    private JButton browse = new JButton(JMeterUtils.getResString("browse"));
    private JButton clear = new JButton(JMeterUtils.getResString("clear"));
    private JButton delete = new JButton(JMeterUtils.getResString("delete"));
    private List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private String title;
    private String filetype;

    public FileListPanel() {
        this.title = "";
        this.init();
    }

    public FileListPanel(String title) {
        this.title = title;
        this.init();
    }

    public FileListPanel(String title, String filetype) {
        this.title = title;
        this.filetype = filetype;
        this.init();
    }

    public FileListPanel(ChangeListener l, String title) {
        this.title = title;
        this.init();
        this.listeners.add(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        JLabel jtitle = new JLabel(this.title);
        HorizontalPanel buttons = new HorizontalPanel();
        buttons.add(jtitle);
        buttons.add(this.browse);
        buttons.add(this.delete);
        buttons.add(this.clear);
        this.add((Component)buttons, "North");
        this.initializeTableModel();
        this.files = new JTable((TableModel)this.tableModel);
        this.files.setSelectionMode(2);
        this.files.revalidate();
        JScrollPane scrollpane = new JScrollPane(this.files);
        scrollpane.setPreferredSize(new Dimension(100, 80));
        this.add((Component)scrollpane, "Center");
        this.browse.setActionCommand(ACTION_BROWSE);
        this.browse.addActionListener(this);
        this.clear.addActionListener(this);
        this.delete.addActionListener(this);
    }

    public void enableFile(boolean enable) {
        this.browse.setEnabled(enable);
        this.files.setEnabled(false);
    }

    public void addFilename(String f) {
        this.tableModel.addRow((Object)f);
    }

    public void clearFiles() {
        this.tableModel.clearData();
    }

    public void setFiles(String[] files) {
        this.clearFiles();
        for (int idx = 0; idx < files.length; ++idx) {
            this.addFilename(files[idx]);
        }
    }

    public String[] getFiles() {
        String[] _files = new String[this.tableModel.getRowCount()];
        for (int idx = 0; idx < _files.length; ++idx) {
            _files[idx] = (String)this.tableModel.getValueAt(idx, 0);
        }
        return _files;
    }

    protected void deleteFile() {
        int rowSelected = this.files.getSelectedRow();
        if (rowSelected >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void fireFileChanged() {
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(new ChangeEvent(this));
        }
    }

    protected void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{JMeterUtils.getResString(LABEL_LIBRARY)}, new Functor[0], new Functor[0], new Class[]{String.class});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clear) {
            this.clearFiles();
        } else if (e.getActionCommand().equals(ACTION_BROWSE)) {
            JFileChooser chooser = new JFileChooser();
            String start = System.getProperty("user.dir", "");
            chooser.setCurrentDirectory(new File(start));
            chooser.setFileFilter(new JMeterFileFilter(new String[]{this.filetype}));
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            chooser.showOpenDialog(GuiPackage.getInstance().getMainFrame());
            File[] cfiles = chooser.getSelectedFiles();
            if (cfiles != null) {
                for (int idx = 0; idx < cfiles.length; ++idx) {
                    this.addFilename(cfiles[idx].getPath());
                }
                this.fireFileChanged();
            }
        } else if (e.getSource() == this.delete) {
            this.deleteFile();
        } else {
            this.fireFileChanged();
        }
    }
}

