/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.tree;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.gui.ReportGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.testelement.ReportPlan;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;

public class ReportTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 240L;

    public ReportTreeModel() {
        super(new ReportTreeNode(new ReportGui().createTestElement(), null));
        this.initTree();
    }

    public List<ReportTreeNode> getNodesOfType(Class<?> type) {
        LinkedList<ReportTreeNode> nodeList = new LinkedList<ReportTreeNode>();
        this.traverseAndFind(type, (ReportTreeNode)this.getRoot(), nodeList);
        return nodeList;
    }

    public ReportTreeNode getNodeOf(TestElement userObject) {
        return this.traverseAndFind(userObject, (ReportTreeNode)this.getRoot());
    }

    public HashTree addSubTree(HashTree subTree, ReportTreeNode current) throws IllegalUserActionException {
        for (TestElement item : subTree.list()) {
            if (item instanceof ReportPlan) {
                current = (ReportTreeNode)((ReportTreeNode)this.getRoot()).getChildAt(0);
                ((TestElement)current.getUserObject()).addTestElement(item);
                ((ReportPlan)current.getUserObject()).setName(item.getName());
                this.addSubTree(subTree.getTree((Object)item), current);
                continue;
            }
            if (subTree.getTree((Object)item) == null) continue;
            this.addSubTree(subTree.getTree((Object)item), this.addComponent(item, current));
        }
        return this.getCurrentSubTree(current);
    }

    public ReportTreeNode addComponent(TestElement component, ReportTreeNode node) throws IllegalUserActionException {
        if (node.getUserObject() instanceof AbstractConfigGui) {
            throw new IllegalUserActionException("This node cannot hold sub-elements");
        }
        ReportGuiPackage.getInstance().updateCurrentNode();
        JMeterGUIComponent guicomp = ReportGuiPackage.getInstance().getGui(component);
        guicomp.configure(component);
        guicomp.modifyTestElement(component);
        ReportGuiPackage.getInstance().getCurrentGui();
        ReportTreeNode newNode = new ReportTreeNode(component, this);
        try {
            if (component.getProperty("TestElement.enabled") instanceof NullProperty || component.getPropertyAsBoolean("TestElement.enabled")) {
                newNode.setEnabled(true);
            } else {
                newNode.setEnabled(false);
            }
        }
        catch (Exception e) {
            newNode.setEnabled(true);
        }
        this.insertNodeInto(newNode, node, node.getChildCount());
        return newNode;
    }

    public void removeNodeFromParent(ReportTreeNode node) {
        if (!(node.getUserObject() instanceof ReportPlan)) {
            super.removeNodeFromParent(node);
        }
    }

    private void traverseAndFind(Class<?> type, ReportTreeNode node, List<ReportTreeNode> nodeList) {
        if (type.isInstance(node.getUserObject())) {
            nodeList.add(node);
        }
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            ReportTreeNode child = (ReportTreeNode)enumNode.nextElement();
            this.traverseAndFind(type, child, nodeList);
        }
    }

    private ReportTreeNode traverseAndFind(TestElement userObject, ReportTreeNode node) {
        if (userObject == node.getUserObject()) {
            return node;
        }
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            ReportTreeNode child = (ReportTreeNode)enumNode.nextElement();
            ReportTreeNode result = this.traverseAndFind(userObject, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HashTree getCurrentSubTree(ReportTreeNode node) {
        ListedHashTree hashTree = new ListedHashTree((Object)node);
        Enumeration<TreeNode> enumNode = node.children();
        while (enumNode.hasMoreElements()) {
            ReportTreeNode child = (ReportTreeNode)enumNode.nextElement();
            hashTree.add((Object)node, this.getCurrentSubTree(child));
        }
        return hashTree;
    }

    public HashTree getReportPlan() {
        return this.getCurrentSubTree((ReportTreeNode)((ReportTreeNode)this.getRoot()).getChildAt(0));
    }

    public void clearTestPlan() {
        super.removeNodeFromParent((ReportTreeNode)this.getChild(this.getRoot(), 0));
        this.initTree();
    }

    private void initTree() {
        TestElement rp = new ReportGui().createTestElement();
        this.insertNodeInto(new ReportTreeNode(rp, this), (ReportTreeNode)this.getRoot(), 0);
    }
}

