/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.jorphan.util.JOrphanUtils;

public class BeanShellClient {
    private static final int MINARGS = 3;

    public static void main(String[] args) throws Exception {
        int b;
        if (args.length < 3) {
            System.out.println("Please provide 3 or more arguments:");
            System.out.println("serverhost serverport filename [arg1 arg2 ...]");
            System.out.println("e.g. ");
            System.out.println("localhost 9000 extras/remote.bsh apple blake 7");
            return;
        }
        String host = args[0];
        String portString = args[1];
        String file = args[2];
        int port = Integer.parseInt(portString) + 1;
        System.out.println("Connecting to BSH server on " + host + ":" + portString);
        Socket sock = new Socket(host, port);
        InputStream is = sock.getInputStream();
        OutputStream os = sock.getOutputStream();
        FileReader fis = new FileReader(file);
        new SockRead(is).start();
        BeanShellClient.sendLine("bsh.prompt=\"\";", os);
        BeanShellClient.sendLine("String [] args={", os);
        for (int i = 3; i < args.length; ++i) {
            BeanShellClient.sendLine("\"" + args[i] + "\",\n", os);
        }
        BeanShellClient.sendLine("};", os);
        while ((b = fis.read()) != -1) {
            os.write(b);
        }
        fis.close();
        BeanShellClient.sendLine("bsh.prompt=\"bsh % \";", os);
        os.flush();
        os.close();
        sock.shutdownOutput();
    }

    private static void sendLine(String line, OutputStream outPipe) throws IOException {
        outPipe.write(line.getBytes());
        outPipe.flush();
    }

    private static class SockRead
    extends Thread {
        private final InputStream is;

        public SockRead(InputStream _is) {
            this.is = _is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Reading responses from server ...");
            int x = 0;
            try {
                while ((x = this.is.read()) > -1) {
                    char c = (char)x;
                    System.out.print(c);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                System.out.println("... disconnected from server.");
                JOrphanUtils.closeQuietly((Closeable)this.is);
            }
        }
    }
}

