/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartText;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.jCharts.chartText.TextTag;
import org.jCharts.properties.util.ChartFont;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

public class TextTagGroup
implements HTMLTestable,
Serializable {
    private float widestLabel = 0.0f;
    private float tallestLabel = 0.0f;
    private float totalLabelWidths = 0.0f;
    private ArrayList textTags = new ArrayList(30);
    private ChartFont chartFont;
    private FontRenderContext fontRenderContext;

    public TextTagGroup(ChartFont chartFont, FontRenderContext fontRenderContext) {
        this.chartFont = chartFont;
        this.fontRenderContext = fontRenderContext;
    }

    public void addLabel(String string) {
        TextTag textTag = new TextTag(string, this.chartFont.getFont(), this.fontRenderContext);
        this.textTags.add(textTag);
        this.widestLabel = Math.max(textTag.getWidth(), this.widestLabel);
        this.totalLabelWidths += textTag.getWidth();
        this.tallestLabel = Math.max(textTag.getHeight(), this.tallestLabel);
    }

    public int size() {
        return this.textTags.size();
    }

    public void reverse() {
        ArrayList arrayList = new ArrayList(this.textTags.size());
        int n = this.textTags.size() - 1;
        while (n >= 0) {
            arrayList.add(this.textTags.get(n));
            --n;
        }
        this.textTags = arrayList;
    }

    public float getWidestLabel() {
        return this.widestLabel;
    }

    public float getTallestLabel() {
        return this.tallestLabel;
    }

    public float getTotalLabelWidths() {
        return this.totalLabelWidths;
    }

    public TextTag getTextTag(int n) {
        return (TextTag)this.textTags.get(n);
    }

    public void render(int n, Graphics2D graphics2D, float f, float f2) {
        this.chartFont.setupGraphics2D(graphics2D);
        this.getTextTag(n).render(graphics2D, f, f2);
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                hTMLGenerator.addField(fieldArray[n].getName(), fieldArray[n].get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        hTMLGenerator.propertiesTableEnd();
    }
}

