/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.protocol.system.StreamCopier;
import org.apache.jmeter.protocol.system.StreamGobbler;
import org.apache.jorphan.util.JOrphanUtils;

public class NativeCommand {
    private StreamGobbler outputGobbler;
    private final File directory;
    private final Map<String, String> env;
    private Map<String, String> executionEnvironment;
    private final String stdin;
    private final String stdout;
    private final String stderr;

    public NativeCommand(File directory, Map<String, String> env) {
        this(directory, env, null, null, null);
    }

    public NativeCommand(File directory, Map<String, String> env, String stdin, String stdout, String stderr) {
        this.directory = directory;
        this.env = env;
        this.stdin = JOrphanUtils.nullifyIfEmptyTrimmed((String)stdin);
        this.stdout = JOrphanUtils.nullifyIfEmptyTrimmed((String)stdout);
        this.stderr = JOrphanUtils.nullifyIfEmptyTrimmed((String)stderr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(List<String> arguments) throws InterruptedException, IOException {
        Process proc = null;
        try {
            ProcessBuilder procBuild = new ProcessBuilder(arguments);
            procBuild.environment().putAll(this.env);
            this.executionEnvironment = Collections.unmodifiableMap(procBuild.environment());
            procBuild.directory(this.directory);
            if (this.stderr == null || this.stderr.equals(this.stdout)) {
                procBuild.redirectErrorStream(true);
            }
            proc = procBuild.start();
            StreamCopier swerr = null;
            if (!procBuild.redirectErrorStream()) {
                swerr = new StreamCopier(proc.getErrorStream(), new FileOutputStream(this.stderr));
                swerr.start();
            }
            StreamCopier swout = null;
            if (this.stdout != null) {
                swout = new StreamCopier(proc.getInputStream(), new FileOutputStream(this.stdout));
                swout.start();
            } else {
                this.outputGobbler = new StreamGobbler(proc.getInputStream());
                this.outputGobbler.start();
            }
            StreamCopier swin = null;
            if (this.stdin != null) {
                swin = new StreamCopier(new FileInputStream(this.stdin), proc.getOutputStream());
                swin.start();
            }
            int exitVal = proc.waitFor();
            if (this.outputGobbler != null) {
                this.outputGobbler.join();
            }
            if (swout != null) {
                swout.join();
            }
            if (swerr != null) {
                swerr.join();
            }
            if (swin != null) {
                swin.interrupt();
                swin.join();
            }
            int n = exitVal;
            return n;
        }
        finally {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public String getOutResult() {
        if (this.outputGobbler != null) {
            return this.outputGobbler.getResult();
        }
        return "";
    }

    public Map<String, String> getExecutionEnvironment() {
        return this.executionEnvironment;
    }
}

